/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.config;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.meta.ConfigContext;
import org.webswing.server.common.model.meta.MetaObject;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.extension.ExtensionClassLoader;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.config.ConfigurationChangeEvent;
import org.webswing.server.services.config.ConfigurationChangeListener;
import org.webswing.server.services.config.ConfigurationProvider;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.config.ConfigurationUpdateHandler;
import org.webswing.server.services.config.DefaultConfigurationProvider;

@Singleton
public class ConfigurationServiceImpl
implements ConfigurationService,
ConfigurationUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    private final ExtensionClassLoader extensionLoader;
    private ConfigurationProvider provider;
    private List<ConfigurationChangeListener> changeListeners = new CopyOnWriteArrayList<ConfigurationChangeListener>();

    @Inject
    public ConfigurationServiceImpl(ExtensionClassLoader extensionLoader) {
        this.extensionLoader = extensionLoader;
    }

    @Override
    public void start() throws WsInitException {
        String providerClassName = System.getProperty("webswing.configProvider", DefaultConfigurationProvider.class.getName());
        try {
            Class<?> providerClass = this.extensionLoader.loadClass(providerClassName);
            try {
                Constructor<?> constructor = providerClass.getDeclaredConstructor(ConfigurationUpdateHandler.class);
                this.provider = (ConfigurationProvider)constructor.newInstance(this);
            }
            catch (NoSuchMethodException e) {
                this.provider = (ConfigurationProvider)providerClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new WsInitException("Could not instantiate configuration provider " + providerClassName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        List<ConfigurationChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.clear();
        }
        if (this.provider != null) {
            try {
                this.provider.dispose();
                this.provider = null;
            }
            catch (Exception e) {
                log.error("Failed to dispose config provider", (Throwable)e);
            }
        }
    }

    @Override
    public SecuredPathConfig getConfiguration(String path) {
        path = ConfigurationServiceImpl.asPath(path);
        Map<String, Object> configuration = this.provider.getConfiguration(path);
        return this.provider.toSecuredPathConfig(path, configuration);
    }

    @Override
    public List<String> getPaths() {
        return this.provider.getPaths();
    }

    @Override
    public void setConfiguration(String path, Map<String, Object> configuration) throws Exception {
        path = ConfigurationServiceImpl.asPath(path);
        if (configuration == null) {
            configuration = this.provider.createDefaultConfiguration(path);
        }
        this.provider.validateConfiguration(path, configuration);
        this.provider.saveConfiguration(path, configuration);
    }

    @Override
    public void removeConfiguration(String path) throws Exception {
        this.provider.removeConfiguration(ConfigurationServiceImpl.asPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerChangeListener(ConfigurationChangeListener listener) {
        List<ConfigurationChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChangeListener(ConfigurationChangeListener listener) {
        List<ConfigurationChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyConfigChanged(String path, SecuredPathConfig newCfg) {
        List<ConfigurationChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (ConfigurationChangeListener listener : this.changeListeners) {
                if (listener == null) continue;
                listener.onConfigChanged(new ConfigurationChangeEvent(ConfigurationServiceImpl.asPath(path), newCfg));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyConfigDeleted(String path) {
        List<ConfigurationChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (ConfigurationChangeListener listener : this.changeListeners) {
                if (listener == null) continue;
                listener.onConfigDeleted(new ConfigurationChangeEvent(ConfigurationServiceImpl.asPath(path), null));
            }
        }
    }

    @Override
    public MetaObject describeConfiguration(String path, Map<String, Object> json, ConfigContext ctx) throws WsException {
        return this.provider.describeConfiguration(ConfigurationServiceImpl.asPath(path), json, ctx, this.extensionLoader);
    }

    @Override
    public boolean isMultiApplicationMode() {
        return this.provider.isMultiApplicationMode();
    }

    protected ConfigurationProvider getProvider() {
        return this.provider;
    }

    public static String asPath(String path) {
        String p = CommonUtil.toPath((String)path);
        if (StringUtils.isBlank((CharSequence)p)) {
            p = "/";
        }
        return p;
    }
}

