/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.jms;

import com.google.inject.Singleton;
import java.util.concurrent.ExecutorService;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.ConstantPendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.transport.nio.SelectorManager;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.usage.SystemUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.jms.JmsService;

@Singleton
public class JmsServiceImpl
implements JmsService {
    private static final Logger log = LoggerFactory.getLogger(JmsService.class);
    private static final long defaultOveralMemLimit = 0x5000000L;
    private static final long defaultDestMemLimit = 0x500000L;
    private BrokerService broker;

    @Override
    public void start() throws WsInitException {
        try {
            System.setProperty("org.apache.activemq.broker.BouncyCastlePosition", "9");
            this.broker = this.startService();
        }
        catch (Exception e) {
            log.error("Failed to start JMS service.", (Throwable)e);
            throw new WsInitException("Failed to start JMS service.", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            if (this.broker != null) {
                this.broker.stop();
                this.broker.waitUntilStopped();
                ((ExecutorService)SelectorManager.getInstance().getSelectorExecutor()).shutdown();
            }
        }
        catch (Exception e) {
            log.error("Failed to stop JMS service.", (Throwable)e);
        }
    }

    public BrokerService startService() throws Exception {
        System.setProperty("org.apache.activemq.SERIALIZABLE_PACKAGES", "*");
        BrokerService broker = new BrokerService();
        broker.setUseJmx(Boolean.getBoolean("webswing.enableActiveMqJmx"));
        broker.setPersistent(false);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        ConstantPendingMessageLimitStrategy pendingMessageLimitStrategy = new ConstantPendingMessageLimitStrategy();
        pendingMessageLimitStrategy.setLimit(10);
        defaultEntry.setPendingMessageLimitStrategy((PendingMessageLimitStrategy)pendingMessageLimitStrategy);
        defaultEntry.setMemoryLimit(this.getDestinationMemoryLimit());
        policyMap.setDefaultEntry(defaultEntry);
        broker.setDestinationPolicy(policyMap);
        SystemUsage memoryManager = new SystemUsage();
        MemoryUsage memoryLimit = new MemoryUsage();
        memoryLimit.setLimit(this.getOveralMemoryLimit());
        memoryManager.setMemoryUsage(memoryLimit);
        broker.setSystemUsage(memoryManager);
        broker.addConnector(System.getProperty("webswing.jmsUrl", "nio://127.0.0.1:34455"));
        broker.start();
        broker.waitUntilStarted();
        return broker;
    }

    private long getOveralMemoryLimit() {
        long result = 0x5000000L;
        if (System.getProperty("webswing.jmsOveralMemoryLimit") != null) {
            try {
                result = Long.parseLong(System.getProperty("webswing.jmsOveralMemoryLimit"));
            }
            catch (NumberFormatException e) {
                log.error("System property webswing.jmsOveralMemoryLimit is not valid. Number value is expected (number of bytes).", (Throwable)e);
            }
        }
        return result;
    }

    private long getDestinationMemoryLimit() {
        long result = 0x500000L;
        if (System.getProperty("webswing.jmsDestinationMemoryLimit") != null) {
            try {
                result = Long.parseLong(System.getProperty("webswing.jmsDestinationMemoryLimit"));
            }
            catch (NumberFormatException e) {
                log.error("System property webswing.jmsDestinationMemoryLimit is not valid. Number value is expected (number of bytes).", (Throwable)e);
            }
        }
        return result;
    }
}

