/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.recorder;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.model.SessionRecordingHeader;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.recorder.SessionRecorder;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.swingmanager.SwingInstanceManager;

public class SessionRecorderImpl
implements SessionRecorder {
    private static final Logger log = LoggerFactory.getLogger(SessionRecorderImpl.class);
    private final SwingInstance swingInstance;
    private final String recordingDir;
    private boolean recording = false;
    private FileOutputStream outputStream;
    private SessionRecordingHeader header;
    private String fileName;
    private long lastFrame = 0L;

    public SessionRecorderImpl(SwingInstance swingInstance, SwingInstanceManager manager) {
        this.swingInstance = swingInstance;
        this.recordingDir = manager.getRecordingsDirPath();
    }

    private static byte[] serializeObject(Serializable o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(o);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            log.error("Failed to serialize object.", (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void saveFrame(byte[] serialized) {
        block7: {
            if (this.recording) {
                try {
                    if (this.outputStream == null) break block7;
                    byte[] length = ByteBuffer.allocate(4).putInt(serialized.length).array();
                    long now = new Date().getTime();
                    this.lastFrame = this.lastFrame == 0L ? now : this.lastFrame;
                    byte[] delay = ByteBuffer.allocate(4).putInt((int)(now - this.lastFrame)).array();
                    this.lastFrame = now;
                    try {
                        this.outputStream.write(delay);
                        this.outputStream.write(length);
                        this.outputStream.write(serialized);
                        this.outputStream.flush();
                    }
                    catch (IOException e) {
                        log.error("Failed to write to session recording file.", (Throwable)e);
                        throw e;
                    }
                }
                catch (Exception e) {
                    log.error("Writing recorded frame failed. Stopping recording session.", (Throwable)e);
                    try {
                        this.stopRecording();
                    }
                    catch (WsException e1) {
                        log.error("Stopping recording session failed.", (Throwable)e1);
                    }
                }
            }
        }
    }

    @Override
    public void startRecording() throws WsException {
        if (!this.recording) {
            try {
                String fileName = URLEncoder.encode(this.swingInstance.getInstanceId(), "UTF-8") + ".wss";
                File folderUri = new File(URI.create(this.recordingDir));
                File file = new File(folderUri, fileName);
                if (file.exists()) {
                    file.delete();
                } else if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                this.fileName = fileName;
                log.info("Starting session recording for " + this.swingInstance.getInstanceId() + " into file:" + file.getAbsolutePath());
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                this.outputStream = new FileOutputStream(file);
                this.header = new SessionRecordingHeader();
                this.header.setClientId(this.swingInstance.getInstanceId());
                this.header.setStartDate(new Date());
                this.lastFrame = this.header.getStartDate().getTime();
                byte[] version = ByteBuffer.allocate(4).putInt(1).array();
                byte[] headerbytes = SessionRecorderImpl.serializeObject(this.header);
                this.outputStream.write(version);
                this.recording = true;
                this.saveFrame(headerbytes);
            }
            catch (FileNotFoundException e) {
                log.error("Failed to create session recording file.", (Throwable)e);
                this.recording = false;
                throw new WsException("Failed to create session recording file.", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Failed to start recording.", (Throwable)e);
                this.recording = false;
                throw new WsException("Failed to start recording.", (Throwable)e);
            }
        } else {
            throw new WsException("Already recording.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void stopRecording() throws WsException {
        if (!this.recording) throw new WsException("Recording not started.");
        try {
            log.info("Stopping session recording for " + this.swingInstance.getInstanceId());
            if (this.outputStream == null) return;
            this.outputStream.flush();
            this.outputStream.close();
            return;
        }
        catch (IOException e) {
            log.error("Failed to close recording file.", (Throwable)e);
            throw new WsException("Failed to close recording file.", (Throwable)e);
        }
        finally {
            this.recording = false;
        }
    }

    @Override
    public boolean isRecording() {
        return this.recording;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }
}

