/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.websocket;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.websocket.WebSocketMessageListener;
import org.webswing.server.services.websocket.WebSocketService;

public interface WebSocketUrlHandler
extends UrlHandler,
WebSocketMessageListener {
    default public boolean serveDefault(HttpServletRequest req, HttpServletResponse res, PrimaryUrlHandler parent, WebSocketService websocket, Logger log) throws WsException {
        if (parent.isSameOrigin(req) || parent.isOriginAllowed(req.getHeader("Origin"))) {
            if (parent.validateCsrfToken(req)) {
                try {
                    websocket.serve(this, req, res);
                    return true;
                }
                catch (Exception e) {
                    log.error("WebSocket failed.", (Throwable)e);
                    throw new WsException("WebSocket failed.", (Throwable)e);
                }
            }
            WsException e = new WsException("Invalid CSRF token", 403);
            log.error("Websocket connection failed: Invalid CSRF token. Received:" + req.getHeader("X-webswing-CSRFToken") + " Expected:" + parent.generateCsrfToken());
            throw e;
        }
        WsException e = new WsException("Invalid request origin", 403);
        log.error("Websocket connection failed: Invalid request origin. Origin:" + req.getHeader("Origin") + " Host:" + req.getHeader("Host") + " X-Forwarded-Host:" + req.getHeader("X-Forwarded-Host"));
        throw e;
    }
}

