/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.rest.resources;

import java.io.File;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.util.VariableSubstitutor;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.rest.resources.BaseRestUtil;
import org.webswing.server.services.rest.resources.RestException;
import org.webswing.server.services.rest.resources.api.BasicApi;
import org.webswing.server.services.rest.resources.api.ManageConfigurationApi;
import org.webswing.server.services.rest.resources.api.ManageSessionsApi;
import org.webswing.server.services.rest.resources.model.ApplicationInfo;
import org.webswing.server.services.rest.resources.model.ApplicationInfoMsg;
import org.webswing.server.services.rest.resources.model.BasicApplicationInfo;
import org.webswing.server.services.rest.resources.model.LogRequest;
import org.webswing.server.services.rest.resources.model.LogResponse;
import org.webswing.server.services.rest.resources.model.Manifest;
import org.webswing.server.services.rest.resources.model.MetaObject;
import org.webswing.server.services.rest.resources.model.Permissions;
import org.webswing.server.services.rest.resources.model.Sessions;
import org.webswing.server.services.rest.resources.model.SwingSession;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.stats.StatisticsLoggerService;
import org.webswing.server.services.stats.logger.InstanceStats;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.util.LogReaderUtil;
import org.webswing.server.util.LoggerStatisticsUtil;

public class SwingAppRestService
implements BasicApi,
ManageConfigurationApi,
ManageSessionsApi {
    @Inject
    SwingInstanceManager manager;
    @Inject
    PrimaryUrlHandler handler;
    @Inject
    ConfigurationService configService;
    @Inject
    StatisticsLoggerService loggerService;
    @Context
    HttpServletResponse response;

    @Override
    public ApplicationInfo getInfo() throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getAppInfo);
            ApplicationInfo app = BaseRestUtil.getAppInfoImpl(this.getHandler());
            app.setName(this.handler.getSwingConfig().getName());
            List<SwingInstance> allRunning = this.manager.getSwingInstanceHolder().getAllInstances();
            app.setRunningInstances(allRunning.size());
            int connected = 0;
            for (SwingInstance si : allRunning) {
                if (si.getConnectionId() == null) continue;
                ++connected;
            }
            app.setConnectedInstances(connected);
            app.setFinishedInstances(this.manager.getSwingInstanceHolder().getAllClosedInstances().size());
            int maxRunningInstances = this.handler.getSwingConfig().getMaxClients();
            app.setMaxRunningInstances(maxRunningInstances);
            app.setStats(this.manager.getStatsReader().getSummaryStats());
            app.setWarnings(this.manager.getStatsReader().getSummaryWarnings());
            return app;
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public List<BasicApplicationInfo> getPaths() throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getPaths);
            BasicApplicationInfo app = new BasicApplicationInfo();
            app.setPath(this.manager.getPathMapping());
            app.setUrl(this.manager.getFullPathMapping());
            app.setEnabled(this.manager.isEnabled());
            app.setName(this.handler.getSwingConfig().getName());
            List<SwingInstance> allRunning = this.manager.getSwingInstanceHolder().getAllInstances();
            app.setRunningInstances(allRunning.size());
            return Arrays.asList(app);
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public Sessions getSessions() throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getSession);
            HashSet localRecordingFiles = new HashSet();
            Sessions result = new Sessions();
            this.manager.getSwingInstanceHolder().getAllInstances().stream().map(si -> si.toSwingSession(false)).forEach(session -> {
                result.getSessions().add((SwingSession)session);
                if (session.getRecordingFile() != null) {
                    localRecordingFiles.add(session.getRecordingFile());
                }
            });
            this.manager.getSwingInstanceHolder().getAllClosedInstances().stream().map(si -> si.toSwingSession(false)).forEach(session -> {
                result.getClosedSessions().add((SwingSession)session);
                if (session.getRecordingFile() != null) {
                    localRecordingFiles.add(session.getRecordingFile());
                }
            });
            ArrayList<String> externalRecordings = new ArrayList<String>();
            if (this.manager.getRecordingsDirPath() != null) {
                File recordingsDir = new File(URI.create(this.manager.getRecordingsDirPath()));
                if (recordingsDir.exists() && recordingsDir.isDirectory() && recordingsDir.canRead()) {
                    for (File rFile : recordingsDir.listFiles()) {
                        if (localRecordingFiles.contains(rFile.getName())) continue;
                        externalRecordings.add(rFile.getName());
                    }
                }
                result.setRecordings(externalRecordings);
            }
            return result;
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public Permissions getPermissions() throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.master_basic_access);
            return BaseRestUtil.getPermissions(this.handler);
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public List<ApplicationInfoMsg> getApps() throws RestException {
        try {
            ApplicationInfoMsg applicationInfoMsg;
            this.getHandler().checkPermission(WebswingAction.rest_getApps);
            ArrayList<ApplicationInfoMsg> result = new ArrayList<ApplicationInfoMsg>();
            if (this.manager.isEnabled() && this.manager.isUserAuthorized() && (applicationInfoMsg = this.manager.getApplicationInfoMsg()) != null) {
                result.add(applicationInfoMsg);
            }
            return result;
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public String getAdminConsoleUrl() throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getAppInfo);
            return this.getHandler().getAdminUrl();
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public String getVersion() throws RestException {
        return BaseRestUtil.getVersion();
    }

    @Override
    public void ping() throws RestException {
    }

    @Override
    public Map<String, Map<String, BigDecimal>> getStats() throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getStats);
            ArrayList<InstanceStats> allStats = new ArrayList<InstanceStats>(this.manager.getStatsReader().getAllInstanceStats());
            allStats.addAll(this.loggerService.getServerLogger().getAllInstanceStats());
            return LoggerStatisticsUtil.mergeSummaryInstanceStats(allStats);
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public MetaObject getConfig() throws RestException {
        return BaseRestUtil.getConfig(this.getHandler(), this.getConfigService());
    }

    @Override
    public MetaObject getMeta(Map<String, Object> requestBody) throws RestException {
        return BaseRestUtil.getMeta(requestBody, this.getHandler(), this.getConfigService());
    }

    @Override
    public void saveConfig(Map<String, Object> config) throws RestException {
        try {
            this.getHandler().checkMasterPermission(WebswingAction.rest_setConfig);
            this.getConfigService().setConfiguration(this.getHandler().getPathMapping(), config);
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    @Override
    public String resolve(String type, String resolve) throws RestException {
        return BaseRestUtil.resolve(type, resolve, this.getHandler());
    }

    @Override
    public Map<String, String> searchVariables(String type, String search) throws RestException {
        return BaseRestUtil.searchVariables(type, search, this.getHandler());
    }

    @Override
    public SwingSession getSession(String id) throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getSession);
            SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
            if (instance != null) {
                return instance.toSwingSession(true);
            }
            return null;
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public SwingSession getMetrics(String uuid) throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.websocket_connect);
            SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByConnectionId(uuid);
            if (instance != null && this.getHandler().getUser().getUserId().equals(instance.getUserId())) {
                return instance.toSwingSession(true);
            }
            return null;
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public SwingSession startRecording(String id) throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_startRecording);
            SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
            if (instance != null) {
                if (instance.isRecording()) {
                    instance.stopRecording();
                } else {
                    instance.startRecording();
                }
                return instance.toSwingSession(true);
            }
            return null;
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public String getThreadDump(String instanceId, String timestamp) throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getThreadDump);
            SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(instanceId);
            if (instance != null) {
                return instance.getThreadDump(timestamp);
            }
            List<SwingInstance> instaces = this.manager.getSwingInstanceHolder().getAllClosedInstances();
            for (SwingInstance i : instaces) {
                String td;
                if (!instanceId.equals(i.getInstanceId()) || (td = i.getThreadDump(timestamp)) == null) continue;
                return td;
            }
            throw new RestException("Not found", 404);
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public void requestThreadDump(String id) throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_requestThreadDump);
            SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
            if (instance != null) {
                instance.requestThreadDump();
            }
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public void shutdown(String id, String forceKill) throws RestException {
        try {
            boolean force = Boolean.parseBoolean(forceKill);
            if (force) {
                this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_sessionShutdown);
            } else {
                this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_sessionShutdownForce);
            }
            SwingInstance instance = this.manager.getSwingInstanceHolder().findInstanceByInstanceId(id);
            if (instance == null) {
                throw new WsException("Instance with id " + id + " not found.");
            }
            instance.shutdown(force);
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public LogResponse getSessionLogs(LogRequest request) throws RestException {
        try {
            this.getHandler().checkMasterPermission(WebswingAction.rest_viewLogs);
            if (StringUtils.isBlank((CharSequence)request.getInstanceId())) {
                return null;
            }
            return LogReaderUtil.readSessionLog(this.getInfo().getUrl(), this.getSessionLogsDir(), request);
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public List<String> getLogInstanceIds() throws RestException {
        try {
            this.getHandler().checkMasterPermission(WebswingAction.rest_viewLogs);
            return LogReaderUtil.readSessionLogInstanceIds(this.getSessionLogsDir(), this.getInfo().getUrl());
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    private String getSessionLogsDir() {
        return LogReaderUtil.getSessionLogDir(VariableSubstitutor.forSwingApp((SecuredPathConfig)this.manager.getConfig()), this.manager.getConfig().getSwingConfig());
    }

    @Override
    public File downloadSessionsLog() throws RestException {
        try {
            this.getHandler().checkMasterPermission(WebswingAction.rest_viewLogs);
            File result = LogReaderUtil.getZippedSessionLog(this.getSessionLogsDir(), this.getInfo().getUrl());
            this.response.setHeader("content-disposition", "attachment; filename = " + LogReaderUtil.normalizeForFileName(this.getInfo().getName()) + "_session_logs.zip");
            return result;
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public String generateCsrfToken() throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.websocket_connect);
            return this.getHandler().generateCsrfToken();
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public Manifest getManifest() throws RestException {
        return BaseRestUtil.getManifest(this.getHandler());
    }

    @Override
    public File getIcon() throws RestException {
        File icon = this.handler.resolveFile(this.handler.getConfig().getIcon());
        if (icon == null) {
            try {
                icon = new File(SwingAppRestService.class.getClassLoader().getResource("images/java.png").toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        this.response.setHeader("Cache-Control", "public, max-age=120");
        return icon;
    }

    private PrimaryUrlHandler getHandler() {
        return this.handler;
    }

    private ConfigurationService getConfigService() {
        return this.configService;
    }
}

