/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.stats.logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.webswing.server.services.stats.logger.Aggregation;
import org.webswing.server.services.stats.logger.MetricRule;
import org.webswing.server.services.stats.logger.Warning;
import org.webswing.server.services.stats.logger.WarningRule;

public class InstanceStats {
    private static final int MAX_WARNING_HISTORY_SIZE = 20;
    private DateFormat format = new SimpleDateFormat("HH:mm:ss");
    private Map<String, Map<Long, Number>> statisticsLog = new ConcurrentHashMap<String, Map<Long, Number>>();
    private Map<String, Long> lastTimestampMap = new ConcurrentHashMap<String, Long>();
    private Map<String, List<Number>> lastTimestampNumbers = new ConcurrentHashMap<String, List<Number>>();
    private Map<String, Number> lastMetrics = new ConcurrentHashMap<String, Number>();
    private Map<String, Warning> warnings = new ConcurrentHashMap<String, Warning>();
    private ConcurrentLinkedQueue<String> warningHistory = new ConcurrentLinkedQueue();
    private Map<String, Number[]> sessionStats = new ConcurrentHashMap<String, Number[]>();

    public void processMetric(final MetricRule rule, String name, Number value, WarningRule warnRule) {
        long timestamp = rule.getInterval() == 0L ? System.currentTimeMillis() : System.currentTimeMillis() / rule.getInterval() * rule.getInterval();
        LinkedHashMap<Long, Number> valueMap = this.statisticsLog.get(name);
        if (valueMap == null) {
            valueMap = new LinkedHashMap<Long, Number>(){
                private static final long serialVersionUID = 3552039647099141391L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<Long, Number> eldest) {
                    if (rule.getInterval() == 0L) {
                        return this.size() > rule.getMetricHistoryLimit();
                    }
                    long current = System.currentTimeMillis() / rule.getInterval() * rule.getInterval();
                    long maxAge = (long)rule.getMetricHistoryLimit() * rule.getInterval();
                    return eldest.getKey() < current - maxAge;
                }
            };
            this.statisticsLog.put(name, (Map<Long, Number>)valueMap);
        }
        if (rule.getInterval() == 0L) {
            valueMap.put(timestamp, value);
            this.lastMetrics.put(name, value);
            this.processWarningRule(name, warnRule);
        } else {
            Long last = this.lastTimestampMap.get(name);
            if (last != null && last != timestamp && this.lastTimestampNumbers.get(name) != null) {
                List<Number> list = this.lastTimestampNumbers.remove(name);
                Number aggregated = this.calculateValue(rule, list);
                valueMap.put(last, aggregated);
                this.calculateSessionValue(rule, name, aggregated);
                this.lastMetrics.put(name, aggregated);
                this.processWarningRule(name, warnRule);
            }
            this.lastTimestampMap.put(name, timestamp);
            if (this.lastTimestampNumbers.get(name) == null) {
                this.lastTimestampNumbers.put(name, new ArrayList());
            }
            this.lastTimestampNumbers.get(name).add(value);
        }
    }

    private void calculateSessionValue(MetricRule rule, String name, Number aggregated) {
        String key = name + "." + (Object)((Object)rule.getAggregation()) + ".SESSION";
        if (!this.sessionStats.containsKey(key)) {
            this.sessionStats.put(key, new Number[]{aggregated, 1});
        } else {
            Number result = 0;
            Number[] values = this.sessionStats.get(key);
            Number lastValue = values[0];
            Number count = values[1];
            switch (rule.getAggregation()) {
                case MIN: {
                    result = Math.min(aggregated.doubleValue(), lastValue.doubleValue());
                    break;
                }
                case MAX: {
                    result = Math.max(aggregated.doubleValue(), lastValue.doubleValue());
                    break;
                }
                case SUM: {
                    result = lastValue.doubleValue() + aggregated.doubleValue();
                    break;
                }
                default: {
                    result = lastValue.doubleValue() + (aggregated.doubleValue() - lastValue.doubleValue()) / count.doubleValue();
                }
            }
            this.sessionStats.replace(key, new Number[]{result, count.doubleValue() + 1.0});
        }
    }

    private void processWarningRule(String name, WarningRule warnRule) {
        if (warnRule != null) {
            Warning warning = warnRule.checkWarning(this.lastMetrics);
            if (warning == null && this.warnings.containsKey(name)) {
                Warning value = this.warnings.remove(name);
                String date = this.format.format(new Date());
                this.warningHistory.add(value + " (until " + date + ")");
                if (this.warningHistory.size() > 20) {
                    this.warningHistory.poll();
                }
            }
            if (warning != null) {
                if (this.warnings.containsKey(name)) {
                    this.warnings.get(name).update(warning);
                } else {
                    this.warnings.put(name, warning);
                }
            }
        }
    }

    private Number calculateValue(MetricRule rule, List<Number> list) {
        Number result = 0;
        if (list != null && list.size() > 0) {
            block4: for (Number number : list) {
                switch (rule.getAggregation()) {
                    case MIN: {
                        result = Math.min(number.doubleValue(), ((Number)result).doubleValue());
                        continue block4;
                    }
                    case MAX: {
                        result = Math.max(number.doubleValue(), ((Number)result).doubleValue());
                        continue block4;
                    }
                }
                result = ((Number)result).doubleValue() + number.doubleValue();
            }
            if (rule.getAggregation().equals((Object)Aggregation.AVG)) {
                result = ((Number)result).doubleValue() / (double)list.size();
            }
            if (rule.getAggregation().equals((Object)Aggregation.AVG_PER_SEC)) {
                result = ((Number)result).doubleValue() / (double)(rule.getInterval() / 1000L);
            }
        }
        return result;
    }

    public Map<String, Number> getMetrics() {
        List<Aggregation> aggregations = Arrays.asList(Aggregation.MIN, Aggregation.MAX, Aggregation.AVG);
        HashMap<String, Number> metrics = new HashMap<String, Number>(this.lastMetrics);
        MetricRule rule = new MetricRule(Aggregation.MIN, 0L, 0);
        for (String name : this.statisticsLog.keySet()) {
            ArrayList<Number> valueList = new ArrayList<Number>(this.statisticsLog.get(name).values());
            for (Aggregation a : aggregations) {
                rule.setAggregation(a);
                metrics.put(name + "." + (Object)((Object)a), this.calculateValue(rule, valueList));
            }
        }
        metrics.putAll(this.getSessionStatistics());
        return metrics;
    }

    public List<String> getWarnings() {
        ArrayList<String> result = new ArrayList<String>();
        for (Warning w : this.warnings.values()) {
            result.add(w.toString());
        }
        return result;
    }

    public Map<String, Map<Long, Number>> getStatistics() {
        return this.statisticsLog;
    }

    public Map<String, Number> getSessionStatistics() {
        Map<String, Number> stats = this.sessionStats.entrySet().stream().collect(Collectors.toMap(p -> (String)p.getKey(), p -> ((Number[])p.getValue())[0]));
        return stats;
    }

    public List<String> getWarningHistory() {
        ArrayList<String> result = new ArrayList<String>(this.warningHistory);
        Collections.reverse(result);
        return result;
    }
}

