/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.stats.logger;

import java.util.Map;
import org.webswing.server.services.stats.logger.Warning;

public abstract class WarningRule {
    public abstract Warning checkWarning(Map<String, Number> var1);

    public static WarningRule memoryUtilizationRule(final double threshold) {
        return new WarningRule(){

            @Override
            public Warning checkWarning(Map<String, Number> lastMetrics) {
                double utilization;
                Number allocated = lastMetrics.get("memoryAllocated");
                Number used = lastMetrics.get("memoryUsed");
                if (allocated != null && allocated.doubleValue() != 0.0 && used != null && (utilization = used.doubleValue() / allocated.doubleValue()) >= threshold) {
                    return WarningRule.warning("memoryUsed", String.format("Utilization is too high! (%.1f)", utilization * 100.0));
                }
                return null;
            }
        };
    }

    public static WarningRule thresholdRule(String metric, double threshold) {
        return WarningRule.thresholdRule(metric, threshold, "Value is too high (%.1f)");
    }

    public static WarningRule thresholdRule(final String metric, final double threshold, final String msg) {
        return new WarningRule(){

            @Override
            public Warning checkWarning(Map<String, Number> lastMetrics) {
                Number value = lastMetrics.get(metric);
                if (metric != null && value.doubleValue() >= threshold) {
                    return WarningRule.warning(metric, String.format(msg, value));
                }
                return null;
            }
        };
    }

    private static Warning warning(String metric, String message) {
        return new Warning(metric, message);
    }
}

