/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.extension.ExtensionService;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.config.ConfigurationChangeListener;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.resources.ResourceHandlerService;
import org.webswing.server.services.rest.RestService;
import org.webswing.server.services.rest.resources.model.InstanceManagerStatus;
import org.webswing.server.services.security.api.BuiltInModules;
import org.webswing.server.services.security.api.SecurityContext;
import org.webswing.server.services.security.api.WebswingSecurityConfig;
import org.webswing.server.services.security.login.LoginHandlerService;
import org.webswing.server.services.security.login.SecuredPathHandler;
import org.webswing.server.services.security.modules.SecurityModuleService;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.services.swingmanager.SwingInstanceManagerService;
import org.webswing.server.util.ServerUtil;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
public class GlobalUrlHandler
extends PrimaryUrlHandler
implements SecuredPathHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalUrlHandler.class);
    private static final String SERVERNAME = System.getProperty("webswing.brandingPrefix", "webswing.org");
    private final ConfigurationService configService;
    private final SwingInstanceManagerService appFactory;
    private final ResourceHandlerService resourceService;
    private final LoginHandlerService loginService;
    private ServletContext servletContext;
    private final ExtensionService extService;
    private final RestService restService;
    private Map<String, SwingInstanceManager> instanceManagers = new LinkedHashMap();
    private final ConfigurationChangeListener changeListener = new /* Unavailable Anonymous Inner Class!! */;

    @Inject
    public GlobalUrlHandler(ConfigurationService config, SwingInstanceManagerService appFactory, ResourceHandlerService resourceService, SecurityModuleService securityService, LoginHandlerService loginService, ServletContext servletContext, ExtensionService extService, RestService restService) {
        super(null, securityService, config);
        this.configService = config;
        this.appFactory = appFactory;
        this.resourceService = resourceService;
        this.loginService = loginService;
        this.servletContext = servletContext;
        this.extService = extService;
        this.restService = restService;
    }

    public void init() {
        this.registerChildUrlHandler((UrlHandler)this.loginService.createLoginHandler((UrlHandler)this));
        this.registerChildUrlHandler((UrlHandler)this.loginService.createLogoutHandler((UrlHandler)this));
        for (UrlHandler handler : this.extService.createExtHandlers((PrimaryUrlHandler)this)) {
            this.registerChildUrlHandler(handler);
        }
        this.registerChildUrlHandler((UrlHandler)this.resourceService.create((PrimaryUrlHandler)this, (SecurityContext)this));
        this.registerChildUrlHandler((UrlHandler)this.restService.createGlobalRestHandler(this));
        this.loadApplications();
        this.configService.registerChangeListener(this.changeListener);
        super.init();
        if (!InstanceManagerStatus.StatusEnum.RUNNING.equals((Object)this.getStatus().getStatus())) {
            throw new RuntimeException("Failed to start primary handler.");
        }
    }

    public void destroy() {
        this.configService.removeChangeListener(this.changeListener);
        this.instanceManagers.clear();
        super.destroy();
    }

    public boolean serve(HttpServletRequest req, HttpServletResponse res) {
        try {
            this.setSecurityHeaders(req, res);
            boolean served = super.serve(req, res);
            if (!served) {
                throw new WsException("Not Found.", 404);
            }
        }
        catch (Exception e) {
            this.handleException(e, req, res);
        }
        return true;
    }

    private void setSecurityHeaders(HttpServletRequest req, HttpServletResponse res) {
        res.addHeader("Server", SERVERNAME);
        if (!Boolean.getBoolean("webswing.disableHttpSecurityHeaders")) {
            if (!ServerUtil.isAdminUrlSameOrigin((String)this.getAdminUrl(), (String)req.getHeader("Referer"))) {
                res.addHeader("X-Frame-Options", "SAMEORIGIN");
            }
            res.addHeader("X-Content-Type-Options", "nosniff");
            res.addHeader("X-XSS-Protection", "1; mode=block");
            res.addHeader("Referrer-Policy", "strict-origin-when-cross-origin");
            if (StringUtils.equalsIgnoreCase((CharSequence)req.getScheme(), (CharSequence)"https")) {
                res.addHeader("Strict-Transport-Security", "1; mode=block");
            }
        }
    }

    protected WebswingSecurityConfig getSecurityConfig() {
        log.info("Loading master security module.(" + this.getConfig().getSecurity() + ").");
        WebswingSecurityConfig secConfig = super.getSecurityConfig();
        if (BuiltInModules.INHERITED.name().equals(secConfig.getModule())) {
            log.error("Master security module INHERITED is not valid. Falling back to default module EMBEDDED.");
            SecuredPathConfig newconfig = this.getConfig();
            newconfig.getSecurity().put("module", BuiltInModules.EMBEDDED.name());
            secConfig = (WebswingSecurityConfig)newconfig.getValueAs("security", WebswingSecurityConfig.class);
        }
        return secConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadApplications() {
        log.info("Loading configured Applications.");
        Map map = this.instanceManagers;
        synchronized (map) {
            for (String path : this.configService.getPaths()) {
                SecuredPathConfig configPath = this.configService.getConfiguration(path);
                String pathMapping = GlobalUrlHandler.toPath((String)path);
                if (GlobalUrlHandler.toPath((String)"/").equals(pathMapping)) continue;
                SwingInstanceManager childHandler = (SwingInstanceManager)this.instanceManagers.get(pathMapping);
                if (childHandler == null) {
                    this.installApplication(configPath);
                    continue;
                }
                log.error("Application with path '" + pathMapping + "' already exists! Application skipped.", (Throwable)new IllegalStateException("Invalid Application configuration."));
            }
        }
    }

    public SwingInstanceManager installApplication(SecuredPathConfig swing) {
        log.info("Installing application " + swing.getPath());
        SwingInstanceManager app = this.appFactory.createApp((UrlHandler)this, swing.getPath());
        this.registerFirstChildUrlHandler((UrlHandler)app);
        return app;
    }

    public void uninstallApplication(SwingInstanceManager appToRemove) {
        log.info("Removing application " + appToRemove.getPathMapping());
        appToRemove.destroy();
        this.removeChildUrlHandler((UrlHandler)appToRemove);
    }

    private void handleException(Exception e, HttpServletRequest req, HttpServletResponse res) {
        log.debug("Failed to process request. " + req.getPathInfo(), (Throwable)e);
        try {
            if (e instanceof WsException) {
                if (!res.isCommitted()) {
                    WsException wse = (WsException)e;
                    res.sendError(wse.getReponseCode(), wse.getLocalizedMessage());
                }
            } else {
                log.error("Failed to process request. " + req.getPathInfo(), (Throwable)e);
                if (!res.isCommitted()) {
                    res.setStatus(500);
                    e.printStackTrace(new PrintStream((OutputStream)res.getOutputStream()));
                }
            }
        }
        catch (IOException e1) {
            log.error("Failed send error response to client. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFirstChildUrlHandler(UrlHandler handler) {
        super.registerFirstChildUrlHandler(handler);
        if (handler instanceof SwingInstanceManager) {
            Map map = this.instanceManagers;
            synchronized (map) {
                SwingInstanceManager manager = (SwingInstanceManager)handler;
                this.instanceManagers.put(manager.getPathMapping(), manager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChildUrlHandler(UrlHandler handler) {
        super.registerChildUrlHandler(handler);
        if (handler instanceof SwingInstanceManager) {
            Map map = this.instanceManagers;
            synchronized (map) {
                SwingInstanceManager manager = (SwingInstanceManager)handler;
                this.instanceManagers.put(manager.getPathMapping(), manager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildUrlHandler(UrlHandler handler) {
        super.removeChildUrlHandler(handler);
        if (handler instanceof SwingInstanceManager) {
            Map map = this.instanceManagers;
            synchronized (map) {
                SwingInstanceManager manager = (SwingInstanceManager)handler;
                this.instanceManagers.remove(manager.getPathMapping(), manager);
            }
        }
    }

    protected String getPath() {
        return "";
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SwingInstanceManager> getApplications() {
        ArrayList<SwingInstanceManager> result = new ArrayList<SwingInstanceManager>();
        Map map = this.instanceManagers;
        synchronized (map) {
            result.addAll(this.instanceManagers.values());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwingInstanceManager getApplication(String path) {
        Map map = this.instanceManagers;
        synchronized (map) {
            return (SwingInstanceManager)this.instanceManagers.get(path);
        }
    }

    public URL getWebResource(String resource) {
        if (!this.isCustomIndexPage() && StringUtils.equals((CharSequence)"/index.html", (CharSequence)GlobalUrlHandler.toPath((String)resource))) {
            resource = System.getProperty("webswing.defaultWelcomePage", "/selector/index.html");
        }
        return super.getWebResource(resource);
    }

    private boolean isCustomIndexPage() {
        String customFolder = this.getConfig().getWebFolder();
        if (StringUtils.isBlank((CharSequence)customFolder)) {
            return false;
        }
        File customFolderFile = this.resolveFile(customFolder);
        return customFolderFile != null && customFolderFile.isDirectory() && new File(customFolderFile, "index.html").isFile();
    }

    static /* synthetic */ Map access$000(GlobalUrlHandler x0) {
        return x0.instanceManagers;
    }
}

