/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.security.login;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.AbstractUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.security.LogoutTokenAdapter;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.WebswingSecurityModule;
import org.webswing.server.services.security.login.LogoutHandler;
import org.webswing.server.services.websocket.WebSocketService;

public class LogoutHandlerImpl
extends AbstractUrlHandler
implements LogoutHandler {
    private static final Logger log = LoggerFactory.getLogger(LogoutHandlerImpl.class);
    private final WebSocketService webSockets;

    public LogoutHandlerImpl(WebSocketService webSockets, UrlHandler parent) {
        super(parent);
        this.webSockets = webSockets;
    }

    protected String getPath() {
        return "logout";
    }

    public boolean serve(HttpServletRequest req, HttpServletResponse res) throws WsException {
        AbstractWebswingUser user;
        try {
            if ("OPTIONS".equals(req.getMethod())) {
                return true;
            }
            user = this.logout(req, res);
        }
        catch (Exception e) {
            log.error("Failed to logout", (Throwable)e);
            throw new WsException("Failed to logout", (Throwable)e);
        }
        WebswingSecurityModule securityModuleWrapper = this.getSecurityProvider().get();
        try {
            securityModuleWrapper.doLogout(req, res, user);
        }
        catch (Exception e) {
            log.error("Failed Logout by SecurityModule.", (Throwable)e);
            throw new WsException("Failed Logout by SecurityModule.", (Throwable)e);
        }
        return true;
    }

    protected AbstractWebswingUser logout(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        AbstractWebswingUser user = this.getUser();
        if (user != null) {
            Subject subject = SecurityUtils.getSubject();
            try {
                subject.login((AuthenticationToken)new LogoutTokenAdapter(this.getSecuredPath(), user));
            }
            catch (AuthenticationException e) {
                this.webSockets.disconnectWebsockets(subject.getSession().getId());
                subject.logout();
            }
            return user;
        }
        return null;
    }
}

