/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.swingmanager;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.model.MsgOut;
import org.webswing.model.c2s.ConnectionHandshakeMsgIn;
import org.webswing.model.s2c.SimpleEventMsgOut;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.SwingConfig;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.common.util.VariableSubstitutor;
import org.webswing.server.extension.ExtensionService;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.files.FileTransferHandler;
import org.webswing.server.services.files.FileTransferHandlerService;
import org.webswing.server.services.resources.ResourceHandlerService;
import org.webswing.server.services.rest.RestService;
import org.webswing.server.services.rest.resources.model.ApplicationInfoMsg;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.AuthorizationConfig;
import org.webswing.server.services.security.api.SecurityContext;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.security.login.LoginHandlerService;
import org.webswing.server.services.security.modules.SecurityModuleService;
import org.webswing.server.services.stats.StatisticsLogger;
import org.webswing.server.services.stats.StatisticsLoggerService;
import org.webswing.server.services.stats.StatisticsReader;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.swinginstance.SwingInstanceService;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.services.swingmanager.instance.SwingInstanceHolder;
import org.webswing.server.services.websocket.WebSocketConnection;
import org.webswing.server.services.websocket.WebSocketService;
import org.webswing.server.util.ServerUtil;

public class SwingInstanceManagerImpl
extends PrimaryUrlHandler
implements SwingInstanceManager {
    private static final Logger log = LoggerFactory.getLogger(SwingInstanceManagerImpl.class);
    private final String path;
    private final SwingInstanceService instanceFactory;
    private final WebSocketService websocket;
    private final LoginHandlerService loginService;
    private final ResourceHandlerService resourceService;
    private StatisticsLogger statsLogger;
    private FileTransferHandler fileHandler;
    private final ExtensionService extService;
    private final RestService restService;
    private final SwingInstanceHolder instanceHolder;

    public SwingInstanceManagerImpl(UrlHandler parent, String path, SwingInstanceService instanceFactory, WebSocketService websocket, FileTransferHandlerService fileService, LoginHandlerService loginService, ResourceHandlerService resourceService, SecurityModuleService securityModuleService, ConfigurationService configService, StatisticsLoggerService loggerService, ExtensionService extService, RestService restService, SwingInstanceHolder instanceHolder) {
        super(parent, securityModuleService, configService);
        this.path = path;
        this.instanceFactory = instanceFactory;
        this.websocket = websocket;
        this.loginService = loginService;
        this.resourceService = resourceService;
        this.statsLogger = loggerService.createLogger();
        this.fileHandler = fileService.create((SwingInstanceManager)this);
        this.extService = extService;
        this.restService = restService;
        this.instanceHolder = instanceHolder;
    }

    public void init() {
        this.registerChildUrlHandler((UrlHandler)this.websocket.createPlaybackWebSocketHandler((PrimaryUrlHandler)this, (SwingInstanceManager)this));
        this.registerChildUrlHandler((UrlHandler)this.websocket.createBinaryWebSocketHandler((PrimaryUrlHandler)this, (SwingInstanceManager)this));
        this.registerChildUrlHandler((UrlHandler)this.websocket.createJsonWebSocketHandler((PrimaryUrlHandler)this, (SwingInstanceManager)this));
        this.registerChildUrlHandler((UrlHandler)this.loginService.createLoginHandler((UrlHandler)this));
        this.registerChildUrlHandler((UrlHandler)this.loginService.createLogoutHandler((UrlHandler)this));
        this.registerChildUrlHandler((UrlHandler)this.fileHandler);
        for (UrlHandler handler : this.extService.createExtHandlers((PrimaryUrlHandler)this)) {
            this.registerChildUrlHandler(handler);
        }
        this.registerChildUrlHandler((UrlHandler)this.resourceService.create((PrimaryUrlHandler)this, (SecurityContext)this));
        this.registerChildUrlHandler((UrlHandler)this.restService.createSwingAppRestHandler((PrimaryUrlHandler)this));
        super.init();
    }

    public void destroy() {
        for (SwingInstance i : this.instanceHolder.getAllInstances()) {
            i.kill(0);
        }
        super.destroy();
    }

    protected String getPath() {
        return this.path;
    }

    public void connectView(ConnectionHandshakeMsgIn handshake, WebSocketConnection r) {
        try {
            this.checkAuthorization();
            if (!this.isEnabled()) {
                throw new WsException("This application is disabled.");
            }
            if (handshake.isMirrored()) {
                this.checkPermissionLocalOrMaster(WebswingAction.websocket_startMirrorView);
            }
        }
        catch (WsException e1) {
            log.error("User authorization failed. {}", (Object)e1.getMessage());
            r.broadcastMessage((MsgOut)SimpleEventMsgOut.unauthorizedAccess.buildMsgOut());
            return;
        }
        try {
            SwingInstance instance = this.instanceHolder.findInstanceByConnectionId(r.uuid());
            if (instance == null) {
                if (handshake.isMirrored()) {
                    instance = this.instanceHolder.findInstanceByInstanceId(handshake.getClientId());
                } else {
                    String ownerId = ServerUtil.resolveOwnerIdForSessionMode((WebSocketConnection)r, (ConnectionHandshakeMsgIn)handshake, (SwingConfig)this.getSwingConfig());
                    instance = this.instanceHolder.findInstanceByOwnerId(ownerId);
                }
            }
            if (instance != null) {
                instance.connectSwingInstance(r, handshake);
            } else {
                if (handshake.isMirrored()) {
                    throw new WsException("Instance not found!");
                }
                this.startSwingInstance(r, handshake);
            }
        }
        catch (WsException e) {
            log.error("Failed to connect to instance. ", (Throwable)e);
            r.broadcastMessage((MsgOut)SimpleEventMsgOut.configurationError.buildMsgOut());
        }
    }

    private void startSwingInstance(WebSocketConnection r, ConnectionHandshakeMsgIn h) {
        if (r.hasPermission(WebswingAction.websocket_startSwingApplication)) {
            if (!h.isMirrored()) {
                if (!this.reachedMaxConnections()) {
                    try {
                        SwingInstance swingInstance = this.instanceFactory.create((SwingInstanceManager)this, this.fileHandler, h, this.getSwingConfig(), r);
                        this.instanceHolder.add(swingInstance);
                    }
                    catch (Exception e) {
                        log.error("Failed to create Application instance.", (Throwable)e);
                    }
                } else {
                    r.broadcastMessage((MsgOut)SimpleEventMsgOut.tooManyClientsNotification.buildMsgOut());
                }
            } else {
                r.broadcastMessage((MsgOut)SimpleEventMsgOut.configurationError.buildMsgOut());
            }
        } else {
            log.error("Authorization error: User " + r.getUser() + " is not authorized to connect to application " + this.getSwingConfig().getName() + (h.isMirrored() ? " [Mirrored view only available for admin role]" : ""));
        }
    }

    protected void killAll() {
        for (SwingInstance si : this.instanceHolder.getAllInstances()) {
            si.shutdown(true);
        }
    }

    private boolean reachedMaxConnections() {
        if (this.getSwingConfig().getMaxClients() < 0) {
            return false;
        }
        if (this.getSwingConfig().getMaxClients() == 0) {
            return true;
        }
        return this.instanceHolder.getRunningInstacesCount() >= this.getSwingConfig().getMaxClients();
    }

    public void notifySwingClose(SwingInstance swingInstance) {
        this.instanceHolder.remove(swingInstance);
        swingInstance.logWarningHistory();
        this.statsLogger.removeInstance(swingInstance.getInstanceId());
    }

    public List<SwingInstanceManager> getApplications() {
        return Arrays.asList(this);
    }

    public ApplicationInfoMsg getApplicationInfoMsg() {
        if (this.getConfig().getSwingConfig() == null) {
            return null;
        }
        ApplicationInfoMsg app = new ApplicationInfoMsg();
        app.setName(this.getSwingConfig().getName());
        app.setUrl(this.getFullPathMapping());
        File icon = this.resolveFile(this.getConfig().getIcon());
        app.setBase64Icon(CommonUtil.loadImage((File)icon));
        return app;
    }

    public void logStatValue(String instance, String name, Number value) {
        this.statsLogger.log(instance, name, value);
    }

    public StatisticsReader getStatsReader() {
        return this.statsLogger;
    }

    private void checkAuthorization() throws WsException {
        if (!this.isUserAuthorized()) {
            throw new WsException("User '" + this.getUser() + "' is not authorized to access application " + this.getPathMapping(), 401);
        }
    }

    public boolean isUserAuthorized() {
        AbstractWebswingUser user = this.getUser();
        if (user == null) {
            return false;
        }
        AuthorizationConfig authorizationConfig = this.getSecurityConfig().getAuthorizationConfig();
        if (authorizationConfig == null || authorizationConfig.getRoles().size() == 0 && authorizationConfig.getUsers().size() == 0) {
            return true;
        }
        VariableSubstitutor subs = VariableSubstitutor.forSwingApp((SecuredPathConfig)this.getConfig());
        for (String role : authorizationConfig.getRoles()) {
            String resolvedRole = subs.replace(role);
            if (!user.hasRole(resolvedRole)) continue;
            return true;
        }
        for (String u : authorizationConfig.getUsers()) {
            String resolvedUser = subs.replace(u);
            if (!user.getUserId().equals(resolvedUser)) continue;
            return true;
        }
        return false;
    }

    public SwingInstanceHolder getSwingInstanceHolder() {
        return this.instanceHolder;
    }

    public String getRecordingsDirPath() {
        VariableSubstitutor subs = VariableSubstitutor.forSwingApp((SecuredPathConfig)this.getConfig());
        if (this.getConfig().getSwingConfig() != null) {
            String recFolderString = subs.replace(this.getConfig().getSwingConfig().getRecordingsFolder());
            try {
                String uri = new File(URI.create(recFolderString)).toURI().toString();
                return uri;
            }
            catch (IllegalArgumentException e) {
                File resolved = this.resolveFile(recFolderString);
                if (resolved != null) {
                    return resolved.toURI().toString();
                }
                File uninitialized = new File(recFolderString);
                return uninitialized.toURI().toString();
            }
        }
        return null;
    }
}

