/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.swingmanager;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.extension.ExtensionService;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.files.FileTransferHandlerService;
import org.webswing.server.services.resources.ResourceHandlerService;
import org.webswing.server.services.rest.RestService;
import org.webswing.server.services.security.login.LoginHandlerService;
import org.webswing.server.services.security.modules.SecurityModuleService;
import org.webswing.server.services.stats.StatisticsLoggerService;
import org.webswing.server.services.swinginstance.SwingInstanceService;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.services.swingmanager.SwingInstanceManagerImpl;
import org.webswing.server.services.swingmanager.SwingInstanceManagerService;
import org.webswing.server.services.swingmanager.instance.SwingInstanceHolder;
import org.webswing.server.services.swingmanager.instance.SwingInstanceHolderService;
import org.webswing.server.services.websocket.WebSocketService;

@Singleton
public class SwingInstanceManagerServiceImpl
implements SwingInstanceManagerService {
    private final WebSocketService websocket;
    private final SwingInstanceService instanceService;
    private final FileTransferHandlerService fileService;
    private final LoginHandlerService loginService;
    private final ResourceHandlerService resourceHandler;
    private final SecurityModuleService securityModuleService;
    private final ConfigurationService configService;
    private final StatisticsLoggerService loggerService;
    private final ExtensionService extService;
    private final RestService restService;
    private final SwingInstanceHolderService instanceHolderService;

    @Inject
    public SwingInstanceManagerServiceImpl(SwingInstanceService instanceFactory, WebSocketService websocket, FileTransferHandlerService fileHandler, LoginHandlerService loginHandler, ResourceHandlerService resourceHandler, SecurityModuleService securityModuleService, ConfigurationService configService, StatisticsLoggerService loggerService, ExtensionService extService, RestService restService, SwingInstanceHolderService instanceHolderService) {
        this.instanceService = instanceFactory;
        this.websocket = websocket;
        this.fileService = fileHandler;
        this.loginService = loginHandler;
        this.resourceHandler = resourceHandler;
        this.securityModuleService = securityModuleService;
        this.configService = configService;
        this.loggerService = loggerService;
        this.extService = extService;
        this.restService = restService;
        this.instanceHolderService = instanceHolderService;
    }

    public SwingInstanceManager createApp(UrlHandler parent, String path) {
        SwingInstanceHolder holder = this.instanceHolderService.createInstanceHolder(path);
        return new SwingInstanceManagerImpl(parent, path, this.instanceService, this.websocket, this.fileService, this.loginService, this.resourceHandler, this.securityModuleService, this.configService, this.loggerService, this.extService, this.restService, holder);
    }
}

