/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.common.model.SwingConfig;
import org.webswing.server.common.util.VariableSubstitutor;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.rest.resources.model.LogRequest;
import org.webswing.server.services.rest.resources.model.LogResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class LogReaderUtil {
    private static final Logger log = LoggerFactory.getLogger(LogReaderUtil.class);
    private static final String WEBSWING_LOG_FILE_TYPE_PREFIX = "webswing.log.file.";
    private static final String WEBSWING_LOG_FILE_TYPE_SESSION = "session";

    public static LogResponse readLog(String type, LogRequest request) throws WsException {
        File f = LogReaderUtil.findLogFile((String)type);
        return LogReaderUtil.readLogInternal((File)f, (LogRequest)request);
    }

    public static LogResponse readSessionLog(String appUrl, String logDir, LogRequest request) throws WsException {
        String appUrlNormalized = LogReaderUtil.normalizeForFileName((String)appUrl);
        String sessionIdNormalized = LogReaderUtil.normalizeForFileName((String)request.getInstanceId());
        String logName = "webswing-" + sessionIdNormalized + "-" + appUrlNormalized + ".session.log";
        File f = LogReaderUtil.findSessionLogFile((String)logDir, (String)logName);
        if (f == null || !f.exists()) {
            return null;
        }
        return LogReaderUtil.readLogInternal((File)f, (LogRequest)request);
    }

    public static List<String> readSessionLogInstanceIds(String logDir, String appUrl) throws WsException {
        LinkedHashSet instanceIds = new LinkedHashSet();
        try {
            Path dirPath = Paths.get(logDir, new String[0]);
            if (!dirPath.toFile().exists()) {
                return Collections.emptyList();
            }
            String appUrlNormalized = LogReaderUtil.normalizeForFileName((String)appUrl);
            Pattern p = Pattern.compile("webswing-(.*)-" + appUrlNormalized + ".session.log");
            Files.newDirectoryStream(dirPath, path -> path.toString().matches(".*" + LogReaderUtil.normalizeForFileName((String)appUrl) + "\\." + "session" + "\\.log\\.?[0-9]*$")).forEach(path -> {
                String instanceId;
                String fileName = path.getFileName().toString();
                Matcher m = p.matcher(fileName);
                if (m.find() && StringUtils.isNotBlank((CharSequence)(instanceId = m.group(1)))) {
                    instanceIds.add(instanceId);
                }
            });
        }
        catch (IOException e) {
            log.error("Error while browsing session log folder for app [" + appUrl + "]", (Throwable)e);
        }
        return new ArrayList<String>(instanceIds);
    }

    private static int getReadSize(long start, long fileSize, LogRequest r) {
        return (int)Math.min(r.getMax(), fileSize - start);
    }

    private static long getStartIndex(long fileSize, LogRequest r) {
        long offset;
        long l = offset = r.getOffset() == -1L ? fileSize - 1L : r.getOffset();
        if (r.getBackwards().booleanValue()) {
            return offset - Math.min(offset, r.getMax());
        }
        return offset;
    }

    private static LogResponse readLogInternal(File f, LogRequest request) throws WsException {
        RandomAccessFile fileHandler = null;
        try {
            fileHandler = new RandomAccessFile(f, "r");
            long startIndex = LogReaderUtil.getStartIndex((long)fileHandler.length(), (LogRequest)request);
            if (startIndex > 0L) {
                for (long filePointer = startIndex - 1L; filePointer < fileHandler.length(); ++filePointer) {
                    fileHandler.seek(filePointer);
                    byte readByte = fileHandler.readByte();
                    if (readByte == 10) break;
                }
            }
            startIndex = fileHandler.getFilePointer();
            byte[] b = new byte[LogReaderUtil.getReadSize((long)startIndex, (long)fileHandler.length(), (LogRequest)request)];
            fileHandler.readFully(b);
            LogResponse result = new LogResponse();
            result.setStartOffset(Long.valueOf(startIndex));
            result.setEndOffset(Long.valueOf(fileHandler.getFilePointer()));
            result.setLog(new String(b));
            LogResponse logResponse = result;
            return logResponse;
        }
        catch (IOException e) {
            throw new WsException("Failed to read log file. " + e.getMessage());
        }
        finally {
            if (fileHandler != null) {
                try {
                    fileHandler.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static File findLogFile(String type) {
        String filename = System.getProperty("webswing.log.file." + type);
        if (filename != null) {
            filename = VariableSubstitutor.basic().replace(filename);
            File file = Paths.get(LogReaderUtil.getDefaultLogDir() + filename, new String[0]).toAbsolutePath().normalize().toFile();
            return file;
        }
        return null;
    }

    private static File findSessionLogFile(String logDir, String logName) {
        return Paths.get(logDir + logName, new String[0]).toAbsolutePath().normalize().toFile();
    }

    private static List<File> findSessionLogFiles(String logDir, String appUrl) {
        ArrayList<File> logFiles = new ArrayList<File>();
        try {
            Path dirPath = Paths.get(logDir, new String[0]);
            if (!dirPath.toFile().exists()) {
                return logFiles;
            }
            Files.newDirectoryStream(dirPath, path -> path.toString().matches(".*" + LogReaderUtil.normalizeForFileName((String)appUrl) + "\\." + "session" + "\\.log\\.?[0-9]*$")).forEach(path -> logFiles.add(path.toFile()));
        }
        catch (IOException e) {
            log.error("Error while browsing session log folder for app [" + appUrl + "]", (Throwable)e);
        }
        return logFiles;
    }

    public static String getSessionLogDir(VariableSubstitutor subs, SwingConfig config) {
        String logDir = subs.replace(config.getLoggingDirectory());
        if (StringUtils.isBlank((CharSequence)logDir)) {
            logDir = LogReaderUtil.getDefaultLogDir();
        } else if (!logDir.endsWith("/") && !logDir.endsWith("\\")) {
            logDir = logDir + "/";
        }
        return logDir;
    }

    private static String getDefaultLogDir() {
        return System.getProperty("webswing.logsDir", "logs/");
    }

    public static String normalizeForFileName(String text) {
        return text.replaceAll("\\W+", "_");
    }

    public static File getZippedLog(String type) throws WsException {
        return LogReaderUtil.zipFiles((List)Lists.newArrayList((Object[])new File[]{LogReaderUtil.findLogFile((String)type)}), (String)type);
    }

    public static File getZippedSessionLog(String logDir, String appUrl) throws WsException {
        return LogReaderUtil.zipFiles((List)LogReaderUtil.findSessionLogFiles((String)logDir, (String)appUrl), (String)(LogReaderUtil.normalizeForFileName((String)appUrl) + "_session"));
    }

    public static File getZippedLogFile(String type) throws WsException {
        return LogReaderUtil.zipFiles((List)Lists.newArrayList((Object[])new File[]{LogReaderUtil.findLogFile((String)type)}), (String)type);
    }

    public static File getZippedSessionLogFile(String logDir, String appUrl) throws WsException {
        return LogReaderUtil.zipFiles((List)LogReaderUtil.findSessionLogFiles((String)logDir, (String)appUrl), (String)(LogReaderUtil.normalizeForFileName((String)appUrl) + "_session"));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static File zipFiles(List<File> files, String zipFileName) throws WsException {
        String tempDir = System.getProperty("webswing.tempDirPath");
        File zip = new File(URI.create(tempDir + zipFileName + ".zip"));
        if (files == null || files.isEmpty()) {
            return null;
        }
        try (FileOutputStream fos = new FileOutputStream(zip);){
            File file;
            try (ZipOutputStream out = new ZipOutputStream(fos);){
                files.forEach(f -> {
                    block8: {
                        try (FileInputStream in = new FileInputStream((File)f);){
                            if (zip.canWrite()) {
                                out.putNextEntry(new ZipEntry(f.getName()));
                                IOUtils.copy((InputStream)in, (OutputStream)out);
                                break block8;
                            }
                            throw new IOException("Can not write to file " + zip.getAbsolutePath());
                        }
                        catch (IOException e) {
                            log.error("Failed to zip the log file.", (Throwable)e);
                        }
                    }
                });
                file = zip;
            }
            return file;
        }
        catch (IOException e) {
            log.error("Failed to zip the log file.", (Throwable)e);
            throw new WsException("Failed to download zipped logs [" + zipFileName + "]!");
        }
    }
}

