/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.webswing.model.s2c.ApplicationInfoMsg;
import org.webswing.server.common.model.meta.MetaField;
import org.webswing.server.services.rest.resources.model.MetaField;
import org.webswing.server.services.rest.resources.model.VariableSetName;

public class ModelConversionFactory {
    public static org.webswing.server.services.rest.resources.model.MetaField convertMF(MetaField mf) {
        org.webswing.server.services.rest.resources.model.MetaField result = new org.webswing.server.services.rest.resources.model.MetaField();
        result.setDescription(mf.getDescription());
        result.setDiscriminator(mf.isDiscriminator());
        result.setLabel(mf.getLabel());
        result.setName(mf.getName());
        result.setPresets(mf.getPresets() != null ? Arrays.asList(mf.getPresets()) : null);
        if (mf.getTab() != null) {
            result.setTab(MetaField.TabEnum.valueOf(mf.getTab().toString().toUpperCase()));
        }
        result.setTableColumns(Optional.ofNullable(mf.getTableColumns()).map(Collection::stream).orElseGet(Stream::empty).map(column -> ModelConversionFactory.convertMF(column)).collect(Collectors.toList()));
        if (mf.getType() != null) {
            result.setType(MetaField.TypeEnum.valueOf(mf.getType().toString().toUpperCase()));
        }
        result.setValue(mf.getValue());
        if (mf.getVariables() != null) {
            result.setVariables(VariableSetName.valueOf(mf.getVariables().toString().toUpperCase()));
        }
        return result;
    }

    public static ApplicationInfoMsg convertAIM(org.webswing.server.services.rest.resources.model.ApplicationInfoMsg aim) {
        ApplicationInfoMsg result = new ApplicationInfoMsg();
        result.setName(aim.getName());
        result.setUrl(aim.getUrl());
        result.setBase64Icon(aim.getBase64Icon());
        return result;
    }
}

