/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.jvmconnection;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.jvmconnection.JvmConnection;
import org.webswing.server.services.jvmconnection.JvmListener;

public class JvmConnectionImpl
implements MessageListener,
JvmConnection {
    private static final Logger log = LoggerFactory.getLogger(JvmConnectionImpl.class);
    private static ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
    private final JvmListener listener;
    private Connection connection;
    private Session session;
    private Queue producerQueue;
    private Queue consumerQueue;
    private MessageProducer producer;
    private MessageConsumer consumer;
    private boolean jmsOpen = false;

    public JvmConnectionImpl(String clientId, JvmListener listener) throws WsException {
        try {
            this.listener = listener;
            this.initialize(clientId);
        }
        catch (Exception e) {
            log.error("Failed to connect to Jvm.", (Throwable)e);
            throw new WsException("Failed to connect to Jvm.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(final String clientId) throws JMSException {
        JvmConnectionImpl jvmConnectionImpl = this;
        synchronized (jvmConnectionImpl) {
            this.connection = connectionFactory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.producerQueue = this.session.createQueue(clientId + "Server2Swing");
            this.consumerQueue = this.session.createQueue(clientId + "Swing2Server");
            this.consumer = this.session.createConsumer((Destination)this.consumerQueue);
            this.consumer.setMessageListener((MessageListener)this);
            this.producer = this.session.createProducer((Destination)this.producerQueue);
            this.jmsOpen = true;
            this.connection.setExceptionListener(new ExceptionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onException(JMSException paramJMSException) {
                    log.warn("JMS encountered an exception: " + paramJMSException.getMessage());
                    try {
                        JvmConnectionImpl jvmConnectionImpl = JvmConnectionImpl.this;
                        synchronized (jvmConnectionImpl) {
                            JvmConnectionImpl.this.consumer.close();
                            JvmConnectionImpl.this.producer.close();
                            JvmConnectionImpl.this.session.close();
                            JvmConnectionImpl.this.connection.close();
                            JvmConnectionImpl.this.jmsOpen = false;
                        }
                    }
                    catch (JMSException e) {
                        log.error("SwingJvmConnection:initialize1", (Throwable)e);
                    }
                    try {
                        JvmConnectionImpl.this.initialize(clientId);
                    }
                    catch (JMSException e) {
                        log.error("SwingJvmConnection:initialize2", (Throwable)e);
                    }
                }
            });
        }
    }

    @Override
    public synchronized void send(Serializable o) {
        if (this.jmsOpen) {
            try {
                if (o instanceof String) {
                    this.producer.send((Message)this.session.createTextMessage((String)((Object)o)));
                } else {
                    this.producer.send((Message)this.session.createObjectMessage(o));
                }
            }
            catch (JMSException e) {
                log.debug("SwingJvmConnection:send", (Throwable)e);
            }
        }
    }

    public void onMessage(Message m) {
        try {
            if (m instanceof ObjectMessage) {
                Serializable o = ((ObjectMessage)m).getObject();
                this.listener.onJvmMessage(o);
            }
        }
        catch (Exception e) {
            log.error("SwingJvmConnection:onMessage", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            JvmConnectionImpl jvmConnectionImpl = this;
            synchronized (jvmConnectionImpl) {
                try {
                    this.consumer.close();
                    this.producer.close();
                    this.session.close();
                    try {
                        ((ActiveMQConnection)this.connection).destroyDestination((ActiveMQDestination)this.consumerQueue);
                        ((ActiveMQConnection)this.connection).destroyDestination((ActiveMQDestination)this.producerQueue);
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
                finally {
                    this.connection.close();
                    this.jmsOpen = false;
                }
            }
        }
        catch (Exception e) {
            log.error("SwingJvmConnection:close", (Throwable)e);
            this.jmsOpen = false;
        }
    }
}

