/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.AbstractUrlHandler;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.rest.RestUrlHandler;
import org.webswing.server.services.rest.resources.RestException;
import org.webswing.server.services.security.api.AbstractWebswingUser;

public class RestUrlHandlerImpl
extends AbstractUrlHandler
implements Container,
RestUrlHandler {
    private static final Logger log = LoggerFactory.getLogger(RestUrlHandlerImpl.class);
    private ApplicationHandler appHandler;
    private static final Type REQUEST_TYPE = new GenericType<Ref<HttpServletRequest>>(){}.getType();
    private static final Type RESPONSE_TYPE = new GenericType<Ref<HttpServletResponse>>(){}.getType();
    private static final RequestScopedInitializerProvider requestScopedInitializer = context -> injectionManager -> {
        ((Ref)injectionManager.getInstance(REQUEST_TYPE)).set((Object)context.getHttpServletRequest());
        ((Ref)injectionManager.getInstance(RESPONSE_TYPE)).set((Object)context.getHttpServletResponse());
    };

    public RestUrlHandlerImpl(UrlHandler parent, AbstractBinder binder, Class ... resources) {
        super(parent);
        this.appHandler = new ApplicationHandler((Application)new RestConfiguration(binder, resources));
    }

    @Override
    public boolean serve(final HttpServletRequest request, final HttpServletResponse response) throws WsException {
        URI requestUri;
        URI baseUri;
        UriBuilder absoluteUriBuilder;
        StringBuffer requestUrl = request.getRequestURL();
        String requestURI = request.getRequestURI();
        try {
            absoluteUriBuilder = UriBuilder.fromUri((String)requestUrl.toString());
        }
        catch (IllegalArgumentException iae) {
            log.warn("Rest request url [" + requestUrl.toString() + "] is invalid.", (Throwable)iae);
            return false;
        }
        String basePath = this.getFullPathMapping() + "/";
        try {
            baseUri = absoluteUriBuilder.replacePath(basePath).build(new Object[0]);
            String queryParameters = ContainerUtils.encodeUnsafeCharacters((String)request.getQueryString());
            if (queryParameters == null) {
                queryParameters = "";
            }
            requestUri = absoluteUriBuilder.replacePath(requestURI).replaceQuery(queryParameters).build(new Object[0]);
        }
        catch (IllegalArgumentException | UriBuilderException ex) {
            log.warn("Rest request url [" + requestURI.toString() + "] is invalid.", ex);
            return false;
        }
        try {
            ResponseWriter responseWriter = new ResponseWriter(response);
            ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, request.getMethod(), this.getSecurityContext(request), (PropertiesDelegate)new MapPropertiesDelegate());
            requestContext.setEntityStream((InputStream)request.getInputStream());
            this.addRequestHeaders(request, requestContext);
            requestContext.setWriter((ContainerResponseWriter)responseWriter);
            requestContext.setRequestScopedInitializer(requestScopedInitializer.get(new RequestContextProvider(){

                @Override
                public HttpServletRequest getHttpServletRequest() {
                    return request;
                }

                @Override
                public HttpServletResponse getHttpServletResponse() {
                    return response;
                }
            }));
            this.appHandler.handle(requestContext);
            return responseWriter.isServed();
        }
        catch (Exception e) {
            log.error("Rest API call failed.", (Throwable)e);
            throw new WsException(e.getMessage(), (Throwable)e);
        }
    }

    private SecurityContext getSecurityContext(final HttpServletRequest request) {
        return new SecurityContext(){
            private final AbstractWebswingUser user;
            private final boolean secure;
            {
                this.user = RestUrlHandlerImpl.this.getUser();
                this.secure = request.isSecure();
            }

            public Principal getUserPrincipal() {
                if (this.user != null) {
                    return new Principal(){

                        @Override
                        public String getName() {
                            return user.getUserId();
                        }
                    };
                }
                return null;
            }

            public boolean isUserInRole(String role) {
                return this.user == null ? false : this.user.hasRole(role);
            }

            public boolean isSecure() {
                return this.secure;
            }

            public String getAuthenticationScheme() {
                return "FORM";
            }
        };
    }

    @Override
    protected String getPath() {
        return "";
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    public ApplicationHandler getApplicationHandler() {
        return this.appHandler;
    }

    public void reload() {
        this.reload(this.getConfiguration());
    }

    public void reload(ResourceConfig configuration) {
        this.appHandler.onShutdown((Container)this);
        this.appHandler = new ApplicationHandler((Application)configuration);
        this.appHandler.onReload((Container)this);
        this.appHandler.onStartup((Container)this);
    }

    private void addRequestHeaders(HttpServletRequest request, ContainerRequest requestContext) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (value == null) continue;
                requestContext.header(name, (Object)value);
            }
        }
    }

    public static interface RequestScopedInitializerProvider {
        public RequestScopedInitializer get(RequestContextProvider var1);
    }

    public static interface RequestContextProvider {
        public HttpServletRequest getHttpServletRequest();

        public HttpServletResponse getHttpServletResponse();
    }

    private static class HttpServletRequestReferencingFactory
    extends ReferencingFactory<HttpServletRequest> {
        @Inject
        public HttpServletRequestReferencingFactory(javax.inject.Provider<Ref<HttpServletRequest>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class HttpServletResponseReferencingFactory
    extends ReferencingFactory<HttpServletResponse> {
        @Inject
        public HttpServletResponseReferencingFactory(javax.inject.Provider<Ref<HttpServletResponse>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private class RestConfiguration
    extends ResourceConfig {
        public RestConfiguration(final AbstractBinder binder, Class[] resources) {
            this.register(new AbstractBinder(){

                protected void configure() {
                    ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(HttpServletRequestReferencingFactory.class).to(HttpServletRequest.class)).proxy(true)).proxyForSameScope(false)).in(RequestScoped.class);
                    ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<HttpServletRequest>>(){})).in(RequestScoped.class);
                    ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(HttpServletResponseReferencingFactory.class).to(HttpServletResponse.class)).proxy(true)).proxyForSameScope(false)).in(RequestScoped.class);
                    ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<HttpServletResponse>>(){})).in(RequestScoped.class);
                }
            });
            this.register(new Feature(){

                public boolean configure(FeatureContext context) {
                    context.register((Object)binder);
                    return true;
                }
            });
            for (Class r : resources) {
                this.register(r);
            }
            this.register(RestExceptionMapper.class);
        }
    }

    @Provider
    public static class RestExceptionMapper
    implements ExceptionMapper<RestException> {
        public Response toResponse(RestException ex) {
            return Response.status((int)ex.getReponseCode()).entity((Object)ex.getMessage()).type("text/plain").build();
        }
    }

    private class ResponseWriter
    implements ContainerResponseWriter {
        private final HttpServletResponse response;
        private boolean served = false;

        public ResponseWriter(HttpServletResponse response) {
            this.response = response;
        }

        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse responseContext) throws ContainerException {
            if (responseContext.getStatus() != 404) {
                this.served = true;
            }
            if (responseContext.hasEntity() && contentLength != -1L && contentLength < Integer.MAX_VALUE) {
                this.response.setContentLength((int)contentLength);
            }
            this.response.setHeader("Cache-Control", "private, max-age=0");
            MultivaluedMap headers = responseContext.getStringHeaders();
            for (Map.Entry e : headers.entrySet()) {
                Iterator it = ((List)e.getValue()).iterator();
                if (!it.hasNext()) continue;
                String header = (String)e.getKey();
                if (this.response.containsHeader(header)) {
                    this.response.setHeader(header, (String)it.next());
                }
                while (it.hasNext()) {
                    this.response.addHeader(header, (String)it.next());
                }
            }
            this.response.setStatus(responseContext.getStatus());
            if (!responseContext.hasEntity()) {
                return null;
            }
            try {
                ServletOutputStream outputStream = this.response.getOutputStream();
                return outputStream;
            }
            catch (IOException e) {
                throw new ContainerException((Throwable)e);
            }
        }

        public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            throw new UnsupportedOperationException("Method suspend is not supported by the container.");
        }

        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            throw new UnsupportedOperationException("Method setSuspendTimeout is not supported by the container.");
        }

        public void commit() {
        }

        public void failure(Throwable error) {
            try {
                if (!this.response.isCommitted()) {
                    this.response.reset();
                }
            }
            finally {
                this.rethrow(error);
            }
        }

        public boolean enableResponseBuffering() {
            return true;
        }

        private void rethrow(Throwable error) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new ContainerException(error);
        }

        public boolean isServed() {
            return this.served;
        }
    }
}

