/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.rest.resources;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.webswing.server.GlobalUrlHandler;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.rest.resources.BaseRestUtil;
import org.webswing.server.services.rest.resources.RestException;
import org.webswing.server.services.rest.resources.api.BasicApi;
import org.webswing.server.services.rest.resources.api.ManageApplicationsApi;
import org.webswing.server.services.rest.resources.api.ManageConfigurationApi;
import org.webswing.server.services.rest.resources.api.ViewLogsApi;
import org.webswing.server.services.rest.resources.model.ApplicationInfo;
import org.webswing.server.services.rest.resources.model.ApplicationInfoMsg;
import org.webswing.server.services.rest.resources.model.BasicApplicationInfo;
import org.webswing.server.services.rest.resources.model.LogRequest;
import org.webswing.server.services.rest.resources.model.LogResponse;
import org.webswing.server.services.rest.resources.model.Manifest;
import org.webswing.server.services.rest.resources.model.MetaObject;
import org.webswing.server.services.rest.resources.model.Permissions;
import org.webswing.server.services.rest.resources.model.Sessions;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.stats.StatisticsLoggerService;
import org.webswing.server.services.stats.logger.InstanceStats;
import org.webswing.server.services.swinginstance.SwingInstance;
import org.webswing.server.services.swingmanager.SwingInstanceManager;
import org.webswing.server.util.LogReaderUtil;
import org.webswing.server.util.LoggerStatisticsUtil;

public class GlobalRestService
implements BasicApi,
ManageApplicationsApi,
ManageConfigurationApi,
ViewLogsApi {
    @Inject
    GlobalUrlHandler handler;
    @Inject
    ConfigurationService configService;
    @Inject
    StatisticsLoggerService loggerService;
    @Context
    HttpServletResponse response;

    @Override
    public ApplicationInfo getInfo() throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getAppInfo);
            ApplicationInfo app = BaseRestUtil.getAppInfoImpl(this.getHandler());
            app.setName("Server");
            return app;
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public List<BasicApplicationInfo> getPaths() throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getPaths);
            ArrayList<BasicApplicationInfo> result = new ArrayList<BasicApplicationInfo>();
            for (SwingInstanceManager appManager : this.getGlobalHandler().getApplications()) {
                BasicApplicationInfo app = this.getBasicApplicationInfo(appManager);
                result.add(app);
            }
            return result;
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public Sessions getSessions() throws RestException {
        try {
            this.getHandler().checkMasterPermission(WebswingAction.rest_getSession);
            Sessions result = new Sessions();
            this.getGlobalHandler().getApplications().forEach(app -> app.getSwingInstanceHolder().getAllInstances().forEach(si -> result.getSessions().add(si.toSwingSession(false))));
            this.getGlobalHandler().getApplications().forEach(app -> app.getSwingInstanceHolder().getAllClosedInstances().forEach(si -> result.getClosedSessions().add(si.toSwingSession(false))));
            return result;
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public Integer activeSessionsCount() throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getStats);
            return this.getGlobalHandler().getApplications().stream().mapToInt(m -> m.getSwingInstanceHolder().getRunningInstacesCount()).sum();
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public Permissions getPermissions() throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.master_basic_access);
            boolean multiApplicationMode = this.configService.isMultiApplicationMode();
            Permissions perm = BaseRestUtil.getPermissions(this.handler);
            perm.setStart(BaseRestUtil.isMasterPermited(this.handler, WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_startApp));
            perm.setStop(BaseRestUtil.isMasterPermited(this.handler, WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_stopApp));
            perm.setRemove(multiApplicationMode && BaseRestUtil.isMasterPermited(this.handler, WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_removeApp));
            perm.setCreate(multiApplicationMode && BaseRestUtil.isMasterPermited(this.handler, WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_createApp));
            perm.setConfigEdit(BaseRestUtil.isMasterPermited(this.handler, WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_getConfig, WebswingAction.rest_setConfig));
            perm.setLogsView(BaseRestUtil.isMasterPermited(this.handler, WebswingAction.rest_viewLogs));
            return perm;
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public List<ApplicationInfoMsg> getApps() throws RestException {
        try {
            this.getHandler().checkPermission(WebswingAction.rest_getApps);
            ArrayList<ApplicationInfoMsg> result = new ArrayList<ApplicationInfoMsg>();
            for (SwingInstanceManager mgr : this.getGlobalHandler().getApplications()) {
                ApplicationInfoMsg applicationInfoMsg;
                if (!mgr.isEnabled() || !mgr.isUserAuthorized() || (applicationInfoMsg = mgr.getApplicationInfoMsg()) == null) continue;
                result.add(applicationInfoMsg);
            }
            return result;
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public String getAdminConsoleUrl() throws RestException {
        try {
            this.getHandler().checkPermissionLocalOrMaster(WebswingAction.rest_getAppInfo);
            return this.getHandler().getAdminUrl();
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public String getVersion() throws RestException {
        return BaseRestUtil.getVersion();
    }

    @Override
    public void ping() throws RestException {
    }

    @Override
    public Map<String, Map<String, BigDecimal>> getStats() throws RestException {
        try {
            this.getHandler().checkMasterPermission(WebswingAction.rest_getStats);
            List<InstanceStats> allStats = this.getGlobalHandler().getApplications().stream().map(app -> app.getStatsReader().getAllInstanceStats()).flatMap(Collection::stream).collect(Collectors.toList());
            allStats.addAll(this.loggerService.getServerLogger().getAllInstanceStats());
            return LoggerStatisticsUtil.mergeSummaryInstanceStats(allStats);
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public File getIcon() throws RestException {
        File icon = this.handler.resolveFile(this.handler.getConfig().getIcon());
        this.response.setHeader("Cache-Control", "public, max-age=120");
        return icon;
    }

    @Override
    public Manifest getManifest() throws RestException {
        return BaseRestUtil.getManifest(this.getHandler());
    }

    @Override
    public void createApp(String path) throws RestException {
        try {
            this.getHandler().checkMasterPermission(WebswingAction.rest_createApp);
            if (!StringUtils.isEmpty((CharSequence)path)) {
                SwingInstanceManager swingManager = this.getGlobalHandler().getApplication(path);
                if (swingManager != null) {
                    throw new RestException("Unable to Create App '" + path + "'. Application already exits.");
                }
            } else {
                throw new RestException("Unable to create App '" + path + "'", 400);
            }
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("enabled", false);
            this.configService.setConfiguration(path, config);
            this.configService.setConfiguration(path, null);
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    @Override
    public void removeApp(String path) throws RestException {
        block5: {
            try {
                this.getHandler().checkMasterPermission(WebswingAction.rest_removeApp);
                if (!StringUtils.isEmpty((CharSequence)path)) {
                    SwingInstanceManager swingManager = this.getGlobalHandler().getApplication(path);
                    if (swingManager == null) break block5;
                    if (!swingManager.isEnabled()) {
                        this.configService.removeConfiguration(path);
                        break block5;
                    }
                    throw new RestException("Unable to Remove App '" + path + "' while running. Stop the app first");
                }
                throw new RestException("Unable to remove App '" + path + "'", 400);
            }
            catch (RestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestException(e);
            }
        }
    }

    @Override
    public void startApp(String path) throws RestException {
        try {
            this.getHandler().checkMasterPermission(WebswingAction.rest_startApp);
            SwingInstanceManager appHandler = this.handler.getApplication(path);
            if (appHandler == null) {
                throw new RestException("Invalid appPath", 400);
            }
            if (!appHandler.isEnabled()) {
                appHandler.initConfiguration();
            }
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public void stopApp(String path) throws RestException {
        try {
            this.getHandler().checkMasterPermission(WebswingAction.rest_stopApp);
            SwingInstanceManager appHandler = this.handler.getApplication(path);
            if (appHandler == null) {
                throw new RestException("Invalid appPath", 400);
            }
            if (appHandler.isEnabled()) {
                appHandler.disable();
            }
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public MetaObject getConfig() throws RestException {
        return BaseRestUtil.getConfig(this.getHandler(), this.getConfigService());
    }

    @Override
    public void saveConfig(Map<String, Object> config) throws RestException {
        try {
            this.getHandler().checkMasterPermission(WebswingAction.rest_setConfig);
            config.put("path", "/");
            this.configService.setConfiguration("/", config);
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    @Override
    public MetaObject getMeta(Map<String, Object> requestBody) throws RestException {
        return BaseRestUtil.getMeta(requestBody, this.getHandler(), this.getConfigService());
    }

    @Override
    public String resolve(String type, String resolve) throws RestException {
        return BaseRestUtil.resolve(type, resolve, this.getHandler());
    }

    @Override
    public Map<String, String> searchVariables(String type, String search) throws RestException {
        return BaseRestUtil.searchVariables(type, search, this.getHandler());
    }

    @Override
    public LogResponse getLogs(String type, LogRequest request) throws RestException {
        try {
            this.getHandler().checkMasterPermission(WebswingAction.rest_viewLogs);
            return LogReaderUtil.readLog(type, request);
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public File downloadLog(String type) throws RestException {
        try {
            this.getHandler().checkMasterPermission(WebswingAction.rest_viewLogs);
            File result = LogReaderUtil.getZippedLog(type);
            this.response.setHeader("content-disposition", "attachment; filename = " + type + ".zip");
            return result;
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    @Override
    public List<BasicApplicationInfo> getAppsForSessionLogView() throws RestException {
        try {
            this.getHandler().checkMasterPermission(WebswingAction.rest_viewLogs);
            this.getHandler().checkMasterPermission(WebswingAction.rest_getApps);
            return this.getGlobalHandler().getApplications().stream().filter(app -> app.getConfig().getSwingConfig().isSessionLogging()).map(app -> this.getBasicApplicationInfo((SwingInstanceManager)app)).collect(Collectors.toList());
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    private BasicApplicationInfo getBasicApplicationInfo(SwingInstanceManager appManager) {
        BasicApplicationInfo app = new BasicApplicationInfo();
        app.setPath(appManager.getPathMapping());
        app.setUrl(appManager.getFullPathMapping());
        app.setEnabled(appManager.isEnabled());
        if (appManager.getConfig() != null && appManager.getConfig().getSwingConfig() != null) {
            app.setName(appManager.getConfig().getSwingConfig().getName());
        }
        List<SwingInstance> allRunning = appManager.getSwingInstanceHolder().getAllInstances();
        app.setRunningInstances(allRunning.size());
        return app;
    }

    private PrimaryUrlHandler getHandler() {
        return this.handler;
    }

    private GlobalUrlHandler getGlobalHandler() {
        return this.handler;
    }

    private ConfigurationService getConfigService() {
        return this.configService;
    }
}

