/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.startup;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import main.Main;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.startup.Initializer;

public class DefaultInitializer
implements Initializer {
    private static final Logger log = LoggerFactory.getLogger(DefaultInitializer.class);

    public DefaultInitializer() {
        try {
            this.start();
        }
        catch (WsInitException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void start() throws WsInitException {
        File tempDir = Main.getTempDir();
        log.info("Using Temp folder:" + tempDir.getAbsolutePath());
        File root = Main.getRootDir();
        log.info("Using Root folder:" + root.getAbsolutePath());
        File configProfile = Main.getConfigProfileDir();
        if (!root.equals(configProfile)) {
            log.info("Using Config profile folder:" + configProfile.getAbsolutePath());
        }
        this.validatePropertyFilePath("webswing.warLocation", null);
        log.info("Using War file:" + System.getProperty("webswing.warLocation"));
        this.validatePropertyFilePath("webswing.configFile", "webswing.config");
        log.info("Using Config file:" + System.getProperty("webswing.configFile"));
    }

    protected void validatePropertyFilePath(String propertyName, String defaultValue) throws WsInitException {
        try {
            String configFilePath = this.getValidURI(System.getProperty(propertyName, defaultValue));
            System.setProperty(propertyName, configFilePath);
        }
        catch (FileNotFoundException e) {
            throw new WsInitException("Invalid system property " + propertyName + ": " + e.getMessage());
        }
    }

    protected String getValidURI(String pathOrUri) throws FileNotFoundException {
        if (pathOrUri != null) {
            try {
                URI uri = URI.create(pathOrUri);
                if (new File(uri).exists()) {
                    return pathOrUri;
                }
                throw new FileNotFoundException("File " + uri.toString() + "not found.");
            }
            catch (IllegalArgumentException e) {
                File relativeConfigFile = new File(Main.getConfigProfileDir(), pathOrUri);
                File absoluteConfigFile = new File(pathOrUri);
                if (relativeConfigFile.exists()) {
                    return relativeConfigFile.toURI().toString();
                }
                if (absoluteConfigFile.exists()) {
                    return absoluteConfigFile.toURI().toString();
                }
                throw new FileNotFoundException("File " + relativeConfigFile.getAbsolutePath() + " or " + absoluteConfigFile.getAbsolutePath() + " not found.");
            }
        }
        throw new FileNotFoundException("Path not specified.");
    }
}

