/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.startup;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.WebswingService;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.startup.StartupService;

@Singleton
public class StartupServiceImpl
implements StartupService {
    private static final Logger log = LoggerFactory.getLogger(StartupServiceImpl.class);
    Set<WebswingService> services;

    @Inject
    public StartupServiceImpl(Set<WebswingService> services) {
        this.services = services;
    }

    @Override
    public void start() throws WsInitException {
        try {
            for (WebswingService service : this.services) {
                log.info("Starting service {}", (Object)service.getClass().getSimpleName());
                service.start();
            }
        }
        catch (WsInitException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WsInitException("Failed to start Webswing. " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void stop() {
        for (WebswingService service : this.services) {
            service.stop();
        }
    }
}

