/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.playback;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.model.c2s.PlaybackCommandMsgIn;
import org.webswing.model.s2c.AppFrameMsgOut;
import org.webswing.model.s2c.ApplicationInfoMsg;
import org.webswing.model.s2c.PlaybackInfoMsg;
import org.webswing.server.model.SessionRecordingHeader;
import org.webswing.server.services.playback.SessionRecordingPlayback;
import org.webswing.server.services.websocket.WebSocketConnection;
import org.webswing.server.util.ServerUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class SessionRecordingPlayback {
    private static final Logger log = LoggerFactory.getLogger(SessionRecordingPlayback.class);
    private FileInputStream fis = null;
    private int numberOfFrames;
    private SessionRecordingHeader header;
    private ScheduledExecutorService sender = Executors.newSingleThreadScheduledExecutor();
    private WebSocketConnection conn;
    private int currentFrame = 0;
    private int allowedFrame = 1;
    private File recordingFile;
    private boolean fastForward;

    public SessionRecordingPlayback(WebSocketConnection r, File recordingFile) {
        try {
            this.conn = r;
            this.recordingFile = recordingFile;
            this.fis = new FileInputStream(recordingFile);
            Integer version = SessionRecordingPlayback.readInt((FileInputStream)this.fis);
            if (1 == version) {
                SessionRecordingHeader h;
                this.header = h = (SessionRecordingHeader)SessionRecordingPlayback.readObject((FileInputStream)this.fis);
                while (SessionRecordingPlayback.readInt((FileInputStream)this.fis) != null) {
                    Integer length = SessionRecordingPlayback.readInt((FileInputStream)this.fis);
                    this.fis.skip(length.intValue());
                    ++this.numberOfFrames;
                }
            } else {
                throw new IOException("Version " + version + " of recording file is not supported. Current supported version is " + 1);
            }
            this.resetStream(recordingFile);
            this.sendNextFrame();
        }
        catch (IOException e) {
            log.error("Failed to read recording file " + recordingFile.getAbsolutePath(), (Throwable)e);
            try {
                if (this.fis != null) {
                    this.fis.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void resetStream(File recordingFile) {
        try {
            this.fis.close();
            this.fis = new FileInputStream(recordingFile);
            SessionRecordingPlayback.readInt((FileInputStream)this.fis);
            SessionRecordingPlayback.readObject((FileInputStream)this.fis);
        }
        catch (Exception e) {
            log.error("Failed to reset recording file. ", (Throwable)e);
        }
    }

    public synchronized void close() {
        try {
            this.fis.close();
        }
        catch (IOException e) {
            log.error("Failed to close recording file. ", (Throwable)e);
        }
    }

    public ApplicationInfoMsg getApplicationInfo() {
        ApplicationInfoMsg aim = new ApplicationInfoMsg();
        aim.setName(this.recordingFile.getPath());
        return aim;
    }

    private static byte[] readFrame(FileInputStream fis) throws IOException {
        Integer length = SessionRecordingPlayback.readInt((FileInputStream)fis);
        if (length == null || length == 0) {
            return null;
        }
        byte[] bytes = new byte[length.intValue()];
        if (length.intValue() == fis.read(bytes)) {
            return bytes;
        }
        throw new IOException("Unexpected end of file. Frame expected.");
    }

    private static Integer readInt(FileInputStream fis) throws IOException {
        byte[] b = new byte[4];
        int length = fis.read(b);
        if (4 == length) {
            return b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | (b[0] & 0xFF) << 24;
        }
        if (length < 1) {
            return null;
        }
        throw new IOException("Unexpected end of file. Integer expected.");
    }

    private static Object readObject(FileInputStream fis) throws IOException {
        SessionRecordingPlayback.readInt((FileInputStream)fis);
        Integer headerLength = SessionRecordingPlayback.readInt((FileInputStream)fis);
        byte[] headerBytes = new byte[headerLength.intValue()];
        if (headerLength.intValue() == fis.read(headerBytes)) {
            ByteArrayInputStream bis = new ByteArrayInputStream(headerBytes);
            ObjectInputStream in = null;
            try {
                Object o;
                in = new ObjectInputStream(bis);
                Object object = o = in.readObject();
                return object;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Class could not be deserialized");
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        throw new IOException("Unexpected end of file. Object expected.");
    }

    public synchronized void sendNextFrame() {
        if (this.currentFrame < this.allowedFrame && this.currentFrame < this.numberOfFrames) {
            try {
                ++this.currentFrame;
                Integer delay = SessionRecordingPlayback.readInt((FileInputStream)this.fis);
                byte[] b = SessionRecordingPlayback.readFrame((FileInputStream)this.fis);
                AppFrameMsgOut frame = ServerUtil.decodePlaybackProto((byte[])b);
                PlaybackInfoMsg playback = new PlaybackInfoMsg();
                playback.setCurrent(this.currentFrame);
                playback.setTotal(this.numberOfFrames);
                frame.setPlayback(playback);
                this.sender.schedule((Runnable)new /* Unavailable Anonymous Inner Class!! */, this.fastForward ? 0L : (long)delay.intValue(), TimeUnit.MILLISECONDS);
            }
            catch (IOException e) {
                log.error("Failed to send next recording frame. ", (Throwable)e);
            }
        } else if (this.currentFrame >= this.numberOfFrames) {
            this.close();
        }
    }

    public synchronized void handlePlaybackControl(PlaybackCommandMsgIn playback) {
        if (playback != null && playback.getCommand() != null) {
            switch (2.$SwitchMap$org$webswing$model$c2s$PlaybackCommandMsgIn$PlaybackCommand[playback.getCommand().ordinal()]) {
                case 1: {
                    this.allowedFrame = this.numberOfFrames;
                    this.fastForward = false;
                    break;
                }
                case 2: {
                    this.allowedFrame = this.currentFrame;
                    break;
                }
                case 3: {
                    this.allowedFrame = this.currentFrame + 1;
                    this.fastForward = true;
                    break;
                }
                case 4: {
                    this.allowedFrame = this.currentFrame + 10;
                    this.fastForward = true;
                    break;
                }
                case 5: {
                    this.allowedFrame = this.currentFrame + 100;
                    this.fastForward = true;
                    break;
                }
                case 6: {
                    this.resetStream(this.recordingFile);
                    this.allowedFrame = 1;
                    this.currentFrame = 0;
                    break;
                }
            }
            this.sendNextFrame();
        }
    }

    static /* synthetic */ WebSocketConnection access$000(SessionRecordingPlayback x0) {
        return x0.conn;
    }
}

