/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.rest.resources;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.common.model.SecuredPathConfig;
import org.webswing.server.common.model.meta.ConfigContext;
import org.webswing.server.common.util.VariableSubstitutor;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.config.ConfigurationService;
import org.webswing.server.services.rest.resources.BaseRestUtil;
import org.webswing.server.services.rest.resources.RestException;
import org.webswing.server.services.rest.resources.model.ApplicationInfo;
import org.webswing.server.services.rest.resources.model.Manifest;
import org.webswing.server.services.rest.resources.model.ManifestIcons;
import org.webswing.server.services.rest.resources.model.MetaObject;
import org.webswing.server.services.rest.resources.model.Permissions;
import org.webswing.server.services.rest.resources.model.VariableSetName;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.toolkit.util.GitRepositoryState;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaseRestUtil {
    private static final String default_version = "unresolved";

    protected static ApplicationInfo getAppInfoImpl(PrimaryUrlHandler h) {
        ApplicationInfo app = new ApplicationInfo();
        app.setPath(h.getPathMapping());
        app.setUrl(h.getFullPathMapping());
        app.setEnabled(Boolean.valueOf(h.isEnabled()));
        app.setConfig((Object)h.getConfig());
        app.setVariables(h.getVariableMap());
        app.setStatus(h.getStatus());
        return app;
    }

    public static MetaObject getConfig(PrimaryUrlHandler handler, ConfigurationService configService) throws RestException {
        try {
            handler.checkPermissionLocalOrMaster(WebswingAction.rest_getConfig);
            return configService.describeConfiguration(handler.getPathMapping(), null, (ConfigContext)handler);
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    private static VariableSubstitutor getVariableSubstitutorByType(String type, PrimaryUrlHandler handler) {
        VariableSubstitutor variableSubstitutor;
        VariableSetName variableType;
        try {
            variableType = VariableSetName.valueOf((String)type);
        }
        catch (Exception e) {
            variableType = VariableSetName.BASIC;
        }
        switch (1.$SwitchMap$org$webswing$server$services$rest$resources$model$VariableSetName[variableType.ordinal()]) {
            case 1: {
                String userName = handler.getUser() == null ? "<webswing user>" : handler.getUser().getUserId();
                variableSubstitutor = VariableSubstitutor.forSwingInstance((SecuredPathConfig)handler.getConfig(), (String)userName, null, (String)"<webswing client Id>", (String)"<webswing client IP address>", (String)"<webswing client locale>", (String)"<webswing client timezone>", (String)"<webswing custom args>");
                break;
            }
            case 2: {
                variableSubstitutor = VariableSubstitutor.forSwingApp((SecuredPathConfig)handler.getConfig());
                break;
            }
            default: {
                variableSubstitutor = VariableSubstitutor.basic();
            }
        }
        return variableSubstitutor;
    }

    public static Map<String, String> searchVariables(String type, String searchSequence, PrimaryUrlHandler handler) throws RestException {
        try {
            handler.checkPermissionLocalOrMaster(WebswingAction.rest_getConfig);
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
        int VARIABLES_RESULT_COUNT = 10;
        if (searchSequence == null) {
            searchSequence = "";
        }
        searchSequence = searchSequence.toLowerCase();
        TreeMap<String, String> searchResultStartBy = new TreeMap<String, String>();
        TreeMap<String, String> searchResultContains = new TreeMap<String, String>();
        TreeMap variables = new TreeMap(BaseRestUtil.getVariableSubstitutorByType((String)type, (PrimaryUrlHandler)handler).getVariableMap());
        for (Map.Entry variable : variables.entrySet()) {
            if (searchResultStartBy.size() + searchResultContains.size() == 10) break;
            String variableLowerCase = ((String)variable.getKey()).toLowerCase();
            if (variableLowerCase.startsWith(searchSequence)) {
                searchResultStartBy.put((String)variable.getKey(), (String)variable.getValue());
                continue;
            }
            if (variableLowerCase.contains(searchSequence)) {
                searchResultContains.put((String)variable.getKey(), (String)variable.getValue());
                continue;
            }
            String valueLowerCase = ((String)variable.getValue()).toLowerCase();
            if (!valueLowerCase.contains(searchSequence)) continue;
            searchResultContains.put((String)variable.getKey(), (String)variable.getValue());
        }
        LinkedHashMap<String, String> allResults = new LinkedHashMap<String, String>();
        allResults.putAll(searchResultStartBy);
        allResults.putAll(searchResultContains);
        return allResults;
    }

    public static String resolve(String type, String stringToResolve, PrimaryUrlHandler handler) throws RestException {
        try {
            handler.checkPermissionLocalOrMaster(WebswingAction.rest_getConfig);
            if (stringToResolve == null) {
                return null;
            }
            return BaseRestUtil.getVariableSubstitutorByType((String)type, (PrimaryUrlHandler)handler).replace(stringToResolve);
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    public static MetaObject getMeta(Map<String, Object> json, PrimaryUrlHandler handler, ConfigurationService configService) throws RestException {
        try {
            handler.checkPermissionLocalOrMaster(WebswingAction.rest_getConfig);
            return configService.describeConfiguration(handler.getPathMapping(), json, (ConfigContext)handler);
        }
        catch (WsException e) {
            throw new RestException((Exception)((Object)e));
        }
    }

    public static String getVersion() throws RestException {
        String describe = GitRepositoryState.getInstance().getDescribe();
        if (describe == null) {
            return "unresolved";
        }
        return describe;
    }

    public static boolean isPermited(PrimaryUrlHandler handler, WebswingAction ... actions) {
        for (WebswingAction action : actions) {
            boolean master;
            boolean local;
            boolean bl = local = handler.getUser() != null && handler.getUser().isPermitted(action.name());
            if (local || (master = BaseRestUtil.isMasterPermited((PrimaryUrlHandler)handler, (WebswingAction[])actions))) continue;
            return false;
        }
        return true;
    }

    public static boolean isMasterPermited(PrimaryUrlHandler handler, WebswingAction ... actions) {
        for (WebswingAction action : actions) {
            boolean master;
            boolean bl = master = handler.getMasterUser() != null && handler.getMasterUser().isPermitted(action.name());
            if (master) continue;
            return false;
        }
        return true;
    }

    public static Manifest getManifest(PrimaryUrlHandler handler) throws RestException {
        SecuredPathConfig config = handler.getConfig();
        String color = "#FFFFFF";
        Manifest manifest = new Manifest();
        manifest.setName(config.getSwingConfig().getName());
        manifest.setShortName(manifest.getName());
        ManifestIcons icon = new ManifestIcons();
        icon.setSrc(handler.getFullPathMapping() + "/appicon");
        icon.setSizes("256x256");
        manifest.setIcons(Arrays.asList(icon));
        manifest.setStartUrl(handler.getFullPathMapping());
        manifest.setScope(handler.getFullPathMapping());
        manifest.setBackgroundColor(color);
        manifest.setDisplay("fullscreen");
        manifest.setThemeColor(color);
        return manifest;
    }

    public static Permissions getPermissions(PrimaryUrlHandler handler) {
        Permissions permissions = new Permissions();
        permissions.setDashboard(Boolean.valueOf(BaseRestUtil.isPermited((PrimaryUrlHandler)handler, (WebswingAction[])new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo})));
        permissions.setConfigView(Boolean.valueOf(BaseRestUtil.isPermited((PrimaryUrlHandler)handler, (WebswingAction[])new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_getConfig})));
        permissions.setConfigSwingEdit(Boolean.valueOf(BaseRestUtil.isMasterPermited((PrimaryUrlHandler)handler, (WebswingAction[])new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_getConfig, WebswingAction.rest_setConfig})));
        permissions.setSessions(Boolean.valueOf(BaseRestUtil.isPermited((PrimaryUrlHandler)handler, (WebswingAction[])new WebswingAction[]{WebswingAction.rest_getPaths, WebswingAction.rest_getAppInfo, WebswingAction.rest_getSession})));
        return permissions;
    }
}

