/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.security;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.servlet.ShiroHttpServletResponse;
import org.apache.shiro.web.subject.WebSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.security.SecurableService;
import org.webswing.server.services.security.SecurityManagerService;
import org.webswing.server.services.security.WebswingRealmAdapter;
import org.webswing.server.services.security.WebswingWebSessionManager;
import org.webswing.server.util.SecurityUtil;

@Singleton
public class SecurityManagerServiceImpl
implements SecurityManagerService {
    private static final Logger log = LoggerFactory.getLogger(SecurityManagerServiceImpl.class);
    private final DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
    private ServletContext context;

    @Inject
    public SecurityManagerServiceImpl(ServletContext context) {
        this.context = context;
    }

    public void start() {
        log.info("Starting SecurityManagerServiceImpl");
        try {
            this.securityManager.setCacheManager(this.getCacheManager());
            this.securityManager.setSessionManager(this.getSessionManager());
            this.securityManager.setRealm((Realm)new WebswingRealmAdapter());
            SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
        }
        catch (Exception e) {
            log.error("Failed to start security service", (Throwable)e);
            new WsInitException("Failed to start security service", (Throwable)e);
        }
    }

    protected CacheManager getCacheManager() {
        return new MemoryConstrainedCacheManager();
    }

    protected SessionManager getSessionManager() {
        return new WebswingWebSessionManager();
    }

    public void stop() {
        log.info("Stopping SecurityManagerServiceImpl");
        this.securityManager.destroy();
    }

    public Object secure(SecurableService handler, HttpServletRequest req, HttpServletResponse res) {
        ShiroHttpServletRequest request = new ShiroHttpServletRequest(req, this.context, false);
        ShiroHttpServletResponse response = new ShiroHttpServletResponse(res, this.context, request);
        WebSubject.Builder builder = new WebSubject.Builder((SecurityManager)this.securityManager, (ServletRequest)request, (ServletResponse)response);
        builder.host(SecurityUtil.getClientIp((HttpServletRequest)request));
        WebSubject subject = builder.buildWebSubject();
        request.setAttribute("webswingSecuritySubject", (Object)subject);
        return subject.execute((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateSessionLastAccessTime(ShiroHttpServletRequest request, ShiroHttpServletResponse response) {
        Session session;
        Subject subject = SecurityUtils.getSubject();
        if (subject != null && (session = subject.getSession(false)) != null) {
            try {
                session.touch();
            }
            catch (Throwable t) {
                log.error("session.touch() method invocation has failed.  Unable to updatethe corresponding session's last access time based on the incoming request.", t);
            }
        }
    }

    static /* synthetic */ void access$000(SecurityManagerServiceImpl x0, ShiroHttpServletRequest x1, ShiroHttpServletResponse x2) {
        x0.updateSessionLastAccessTime(x1, x2);
    }
}

