/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.security;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.session.mgt.WebSessionKey;
import org.webswing.server.util.SecurityUtil;

public class WebswingWebSessionManager
extends DefaultWebSessionManager {
    private static final String WEBSWING_SESSION_ID = "WebswingSessionId";

    public WebswingWebSessionManager() {
        String proxypath = System.getProperty("webswing.proxyContextPath", "").replaceAll("[^A-Za-z0-9]", "_");
        SimpleCookie cookie = new SimpleCookie(WEBSWING_SESSION_ID + proxypath);
        cookie.setHttpOnly(true);
        boolean serverIsHttpsOnly = Boolean.getBoolean("webswing.httpsOnly");
        cookie.setSecure(serverIsHttpsOnly);
        if (serverIsHttpsOnly) {
            cookie.setSameSite(Cookie.SameSiteOptions.valueOf((String)System.getProperty("webswing.cookieSameSite", "NONE").toUpperCase()));
        }
        this.setSessionIdCookie((Cookie)cookie);
    }

    protected void validate(Session session, SessionKey key) throws InvalidSessionException {
        String sessionIp;
        String currentIp;
        WebSessionKey webkey;
        super.validate(session, key);
        if (Boolean.getBoolean("webswing.linkCookieToIpAddress") && key instanceof WebSessionKey && (webkey = (WebSessionKey)key).getServletRequest() instanceof HttpServletRequest && !StringUtils.equals((CharSequence)(currentIp = SecurityUtil.getClientIp((HttpServletRequest)((HttpServletRequest)webkey.getServletRequest()))), (CharSequence)(sessionIp = session.getHost()))) {
            InvalidSessionException ise = new InvalidSessionException("IP address does not match Session host.");
            this.onInvalidation(session, ise, key);
            throw ise;
        }
    }
}

