/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.webswing.server.common.model.SwingConfig;
import org.webswing.server.common.util.VariableSubstitutor;
import sun.font.TrueTypeFont;

/*
 * Exception performing whole class analysis ignored.
 */
public class FontUtils {
    private static List<String> logicalNames = Arrays.asList("monospaced", "serif", "sansserif", "dialoginput", "dialog");
    private static List<String> styles = Arrays.asList("bolditalic", "italic", "bold", "plain");
    private static String defaultChargroup = System.getProperty("os.name", "").startsWith("Windows") ? "alpbabet" : "latin-1";

    public static String createFontConfiguration(SwingConfig appConfig, VariableSubstitutor subs) throws IOException {
        if (appConfig.getFontConfig() != null && appConfig.getFontConfig().size() > 0) {
            StringBuilder fontConfig = new StringBuilder("version=1\n");
            StringBuilder metadata = new StringBuilder();
            fontConfig.append("sequence.allfonts=").append(defaultChargroup).append("\n");
            Map fonts = FontUtils.buildFontMap((Map)appConfig.getFontConfig(), (VariableSubstitutor)subs);
            Map fontNames = FontUtils.resolveFontNames(new HashSet(fonts.values()));
            String defaultFont = FontUtils.findDefaultFontKey((Map)fonts, (boolean)false);
            String defaultMonospace = FontUtils.findDefaultFontKey((Map)fonts, (boolean)true);
            for (String logicalFont : logicalNames) {
                for (String style : styles) {
                    String key = FontUtils.findFont((String)logicalFont, (String)style, (String)defaultFont, (String)defaultMonospace, (Map)fonts);
                    File file = (File)fonts.get(key);
                    String fullName = (String)fontNames.get(file);
                    fontConfig.append(logicalFont).append(".").append(style).append(".").append(defaultChargroup).append("=").append(fullName).append("\n");
                    metadata.append("#@@").append(logicalFont).append(".").append(style).append("=").append(file.getAbsolutePath()).append("\n");
                }
            }
            for (File fontFile : fontNames.keySet()) {
                String fontName = (String)fontNames.get(fontFile);
                String fontName_ = fontName.replace(' ', '_');
                fontConfig.append("filename.").append(fontName_).append("=").append(StringEscapeUtils.escapeJava((String)fontFile.getCanonicalPath())).append("\n");
                metadata.append("#@@").append(fontName).append("=").append(fontFile.getAbsolutePath()).append("\n");
            }
            fontConfig.append("\n").append((CharSequence)metadata);
            String tempDir = System.getProperty("webswing.tempDirPath");
            File configfile = new File(URI.create(tempDir + URLEncoder.encode(subs.replace("fontconfig-${clientId}.properties"), "UTF-8")));
            FileUtils.writeStringToFile((File)configfile, (String)fontConfig.toString());
            return configfile.getAbsolutePath();
        }
        return null;
    }

    private static String findFont(String logicalFont, String style, String defaultFont, String defaultMonospace, Map<String, File> fonts) {
        if (fonts.containsKey(logicalFont + " " + style)) {
            return logicalFont + " " + style;
        }
        if (fonts.containsKey(logicalFont + " plain")) {
            return logicalFont + " plain";
        }
        if (FontUtils.isMonospaceFont((String)logicalFont)) {
            return defaultMonospace;
        }
        return defaultFont;
    }

    private static Map<String, File> buildFontMap(Map<String, String> fontConfig, VariableSubstitutor subs) {
        HashMap<String, File> result = new HashMap<String, File>();
        for (String key : fontConfig.keySet()) {
            File fontFile;
            String keyValue = subs.replace(key).toLowerCase().trim();
            if (FontUtils.isLogicalFont((String)keyValue) && logicalNames.contains(keyValue)) {
                keyValue = keyValue + " plain";
            }
            if (!(fontFile = new File(subs.replace(fontConfig.get(key)).trim())).exists()) {
                throw new RuntimeException("Loading font " + keyValue + " failed . Font file " + fontFile.getAbsolutePath() + " not found.");
            }
            if (!fontFile.isFile()) {
                throw new RuntimeException("Loading font " + keyValue + " failed . Font file " + fontFile.getAbsolutePath() + " is not a file.");
            }
            result.put(keyValue, fontFile);
        }
        return result;
    }

    private static Map<File, String> resolveFontNames(Set<File> fontFiles) {
        HashMap<File, String> result = new HashMap<File, String>();
        for (File file : fontFiles) {
            try {
                TrueTypeFont ttfFile = new TrueTypeFont(file.getAbsolutePath(), null, 0, false);
                String name = ttfFile.getFullName();
                result.put(file, name);
            }
            catch (Exception e) {
                throw new RuntimeException("Loading TTF font " + file + " failed .", e);
            }
        }
        return result;
    }

    private static String findDefaultFontKey(Map<String, File> fontConfig, boolean preferMonospace) {
        String result = "";
        for (String key : fontConfig.keySet()) {
            if (FontUtils.isLogicalFont((String)key)) {
                String[] logicalFont = key.split(" ");
                String fontName = logicalFont[0];
                String fontStyle = logicalFont.length > 1 ? logicalFont[1] : "plain";
                String resultName = result.split(" ")[0];
                String resultStyle = result.split(" ").length > 1 ? result.split(" ")[1] : "plain";
                int score = logicalNames.indexOf(fontName) * 10 + styles.indexOf(fontStyle);
                int resultScore = logicalNames.indexOf(resultName) * 10 + styles.indexOf(resultStyle);
                if (preferMonospace) {
                    score = FontUtils.isMonospaceFont((String)key) ? score * 10 : score;
                    int n = resultScore = FontUtils.isMonospaceFont((String)result) ? resultScore * 10 : resultScore;
                }
                if (score <= resultScore) continue;
                result = key;
                continue;
            }
            if (!result.isEmpty()) continue;
            result = key;
        }
        return result.isEmpty() ? null : result;
    }

    private static boolean isLogicalFont(String keyValue) {
        for (String logicalName : logicalNames) {
            String remainder;
            if (!keyValue.startsWith(logicalName) || !(remainder = keyValue.substring(logicalName.length()).trim()).isEmpty() && !styles.contains(remainder)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMonospaceFont(String keyValue) {
        return FontUtils.isLogicalFont((String)keyValue) && (keyValue.startsWith("monospaced") || keyValue.startsWith("dialoginput"));
    }
}

