/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.rest.resources.api;

import java.io.File;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.webswing.server.services.rest.resources.RestException;
import org.webswing.server.services.rest.resources.model.LogRequest;
import org.webswing.server.services.rest.resources.model.LogResponse;
import org.webswing.server.services.rest.resources.model.SwingSession;

@Path(value="/")
public interface ManageSessionsApi {
    @GET
    @Path(value="/rest/session/logs")
    @Produces(value={"application/octet-stream"})
    public File downloadSessionsLog() throws RestException;

    @GET
    @Path(value="/rest/CSRFToken")
    @Produces(value={"text/plain"})
    public String generateCsrfToken() throws RestException;

    @GET
    @Path(value="/rest/session/logs/instanceIds")
    @Produces(value={"application/json"})
    public List<String> getLogInstanceIds() throws RestException;

    @GET
    @Path(value="/rest/metrics/{uuid}")
    @Produces(value={"application/json"})
    public SwingSession getMetrics(@PathParam(value="uuid") String var1) throws RestException;

    @GET
    @Path(value="/rest/session/{id}")
    @Produces(value={"application/json"})
    public SwingSession getSession(@PathParam(value="id") String var1) throws RestException;

    @POST
    @Path(value="/rest/session/logs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public LogResponse getSessionLogs(LogRequest var1) throws RestException;

    @GET
    @Path(value="/rest/threadDump/{instanceId}")
    @Produces(value={"text/plain"})
    public String getThreadDump(@PathParam(value="instanceId") String var1, @QueryParam(value="timestamp") String var2) throws RestException;

    @POST
    @Path(value="/rest/threadDump/{instanceId}")
    public void requestThreadDump(@PathParam(value="instanceId") String var1) throws RestException;

    @DELETE
    @Path(value="/rest/session/{id}")
    public void shutdown(@PathParam(value="id") String var1, @QueryParam(value="force") String var2) throws RestException;

    @GET
    @Path(value="/rest/record/{id}")
    @Produces(value={"application/json"})
    public SwingSession startRecording(@PathParam(value="id") String var1) throws RestException;

    @POST
    @Path(value="/rest/toggleStatisticsLogging/{instanceId}/{enabled}")
    public void toggleStatisticsLogging(@PathParam(value="instanceId") String var1, @PathParam(value="enabled") Boolean var2) throws RestException;
}

