/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.stats.logger;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.services.stats.StatisticsLogger;
import org.webswing.server.services.stats.logger.Aggregation;
import org.webswing.server.services.stats.logger.InstanceStats;
import org.webswing.server.services.stats.logger.MetricRule;
import org.webswing.server.services.stats.logger.SummaryStats;
import org.webswing.server.services.stats.logger.WarningRule;

public class DefaultStatisticsLogger
implements StatisticsLogger {
    private static final long STATS_INTERVAL = Long.getLong("webswing.stats.interval", 10L);
    private static final int STATS_HISTORY_LIMIT = Integer.getInteger("webswing.stats.historySize", 60);
    private static final double STATS_WARN_MEMUSAGE = Double.valueOf(System.getProperty("webswing.stats.memUsageWarn", "0.8"));
    private static final int STATS_WARN_LATENCY_TRESHOLD = Integer.getInteger("webswing.stats.latencyWarn", 700);
    private static final int STATS_WARN_PING_TRESHOLD = Integer.getInteger("webswing.stats.pingWarn", 500);
    private static final Logger log = LoggerFactory.getLogger(DefaultStatisticsLogger.class);
    private static final MetricRule DEFAULT_RULE_AVG = new MetricRule(Aggregation.AVG, TimeUnit.SECONDS.toMillis(STATS_INTERVAL), STATS_HISTORY_LIMIT);
    private static final MetricRule DEFAULT_RULE_AVG_PER_SEC = new MetricRule(Aggregation.AVG_PER_SEC, TimeUnit.SECONDS.toMillis(STATS_INTERVAL), STATS_HISTORY_LIMIT);
    private static final MetricRule DEFAULT_RULE_FLAG = new MetricRule(Aggregation.AVG_PER_SEC, 0L, 1);
    private static final Map<String, MetricRule> rules = new HashMap();
    private static final Map<String, WarningRule> warningRules = new HashMap();
    Map<String, InstanceStats> instanceMap = new HashMap();

    public void log(String instance, String name, Number value) {
        if (value != null) {
            log.trace("{},{},{}", new Object[]{instance, name, value});
            this.processMetric(instance, name, value);
        }
    }

    public void processMetric(String instance, String name, Number value) {
        InstanceStats instanceStats = (InstanceStats)this.instanceMap.get(instance);
        if (instanceStats == null) {
            instanceStats = new InstanceStats();
            this.instanceMap.put(instance, instanceStats);
        }
        MetricRule rule = this.findRule(name);
        WarningRule warn = (WarningRule)warningRules.get(name);
        instanceStats.processMetric(rule, name, value, warn);
    }

    private MetricRule findRule(String name) {
        MetricRule rule = (MetricRule)rules.get(name);
        if (rule == null) {
            return DEFAULT_RULE_AVG;
        }
        return rule;
    }

    public Map<String, Map<String, BigDecimal>> getSummaryStats() {
        SummaryStats stats = new SummaryStats();
        for (String name : summaryRulesMap.keySet()) {
            List summaryAggreg = (List)summaryRulesMap.get(name);
            for (Aggregation aggregation : summaryAggreg) {
                stats.aggregate(this.instanceMap.values(), name, aggregation);
            }
        }
        return stats.getStatistics();
    }

    public Map<String, List<String>> getSummaryWarnings() {
        HashMap<String, List<String>> summary = new HashMap<String, List<String>>();
        for (String instanceId : this.instanceMap.keySet()) {
            List warnings = ((InstanceStats)this.instanceMap.get(instanceId)).getWarnings();
            if (warnings == null || warnings.size() <= 0) continue;
            summary.put(instanceId, warnings);
        }
        return summary;
    }

    public Map<String, Map<Long, Number>> getInstanceStats(String instance) {
        InstanceStats stats = (InstanceStats)this.instanceMap.get(instance);
        if (stats != null) {
            return stats.getStatistics();
        }
        return null;
    }

    public Map<String, ? extends Number> getInstanceMetrics(String instance) {
        InstanceStats stats = (InstanceStats)this.instanceMap.get(instance);
        if (stats != null) {
            return stats.getMetrics();
        }
        return null;
    }

    public List<String> getInstanceWarnings(String instance) {
        InstanceStats stats = (InstanceStats)this.instanceMap.get(instance);
        if (stats != null) {
            return stats.getWarnings();
        }
        return null;
    }

    public List<String> getInstanceWarningHistory(String instance) {
        InstanceStats stats = (InstanceStats)this.instanceMap.get(instance);
        if (stats != null) {
            return stats.getWarningHistory();
        }
        return null;
    }

    public void removeInstance(String instance) {
        this.instanceMap.remove(instance);
    }

    public Collection<InstanceStats> getAllInstanceStats() {
        return this.instanceMap.values();
    }

    static {
        rules.put("inboundSize", DEFAULT_RULE_AVG_PER_SEC);
        rules.put("outboundSize", DEFAULT_RULE_AVG_PER_SEC);
        rules.put("webSocketConnected", DEFAULT_RULE_FLAG);
        rules.put("edtThreadBlockedForSeconds", DEFAULT_RULE_FLAG);
        warningRules.put("memoryUsed", WarningRule.memoryUtilizationRule((double)STATS_WARN_MEMUSAGE));
        warningRules.put("latency", WarningRule.thresholdRule((String)"latency", (double)STATS_WARN_LATENCY_TRESHOLD));
        warningRules.put("latencyPing", WarningRule.thresholdRule((String)"latencyPing", (double)STATS_WARN_PING_TRESHOLD));
        warningRules.put("webSocketConnected", WarningRule.thresholdRule((String)"webSocketConnected", (double)2.0, (String)"WebSocket connection failed. Falling back to long-polling."));
        warningRules.put("edtThreadBlockedForSeconds", WarningRule.thresholdRule((String)"edtThreadBlockedForSeconds", (double)10.0, (String)"EDT blocked for %d seconds. See Thread dump for details."));
        summaryRulesMap.put("memoryAllocated", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("memoryUsed", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("inboundSize", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("outboundSize", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("cpuUtilization", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("cpuUtilizationSession", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("cpuUtilizationServer", Arrays.asList(Aggregation.SUM));
        summaryRulesMap.put("latencyPing", Arrays.asList(Aggregation.AVG));
        summaryRulesMap.put("latencyNetworkTransfer", Arrays.asList(Aggregation.AVG));
        summaryRulesMap.put("latencyClientRendering", Arrays.asList(Aggregation.AVG));
        summaryRulesMap.put("latencyServerRendering", Arrays.asList(Aggregation.AVG));
        summaryRulesMap.put("latency", Arrays.asList(Aggregation.MAX));
    }
}

