/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.websocket;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.webswing.server.services.security.SecurableService;
import org.webswing.server.services.security.SecurityManagerService;
import org.webswing.server.services.websocket.SecuredAtmosphereFramework;

class SecuredAtmosphereFramework
extends AtmosphereFramework
implements SecurableService {
    private SecurityManagerService securityManager;

    public SecuredAtmosphereFramework(SecurityManagerService securityManager) {
        this.securityManager = securityManager;
    }

    public AtmosphereFramework init(ServletConfig sc, boolean wrap) throws ServletException {
        AtmosphereFramework fw = super.init(sc, wrap);
        try {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                this.shutdownHook = null;
            }
        }
        catch (IllegalStateException ex) {
            logger.trace("", (Throwable)ex);
        }
        return fw;
    }

    public Action doCometSupport(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        return (Action)this.securityManager.secure((SecurableService)this, (HttpServletRequest)new AtmosphereRequestWrapper(req), (HttpServletResponse)res);
    }

    public Object secureServe(HttpServletRequest req, HttpServletResponse res) throws Exception {
        return super.doCometSupport(((AtmosphereRequestWrapper)req).getOriginal(), (AtmosphereResponse)res);
    }
}

