/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.UrlHandler;
import org.webswing.server.services.security.WebswingPrincipal;
import org.webswing.server.services.security.api.AbstractWebswingUser;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.services.websocket.WebSocketConnection;
import org.webswing.server.util.SecurityUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecurityUtil {
    public static final String CLIENT_IP_SESSION_ATTR = "webswingClientIp";
    private static final Logger log = LoggerFactory.getLogger(SecurityUtil.class);

    public static AbstractWebswingUser getUser(UrlHandler urlHandler) {
        Subject subject = SecurityUtils.getSubject();
        return SecurityUtil.resolveUser((Subject)subject, (UrlHandler)urlHandler);
    }

    public static AbstractWebswingUser getUser(WebSocketConnection connection) {
        try {
            Subject subject = (Subject)connection.getRequest().getAttribute("webswingSecuritySubject");
            UrlHandler urlHandler = connection.getHandler();
            return SecurityUtil.resolveUser((Subject)subject, (UrlHandler)urlHandler);
        }
        catch (ExpiredSessionException e) {
            log.info("User session expired." + e.getMessage());
            return null;
        }
    }

    public static String getRemoteAddr(WebSocketConnection connection) {
        try {
            Subject subject = (Subject)connection.getRequest().getAttribute("webswingSecuritySubject");
            String ip = (String)subject.getSession().getAttribute((Object)"webswingClientIp");
            if (ip != null) {
                return ip;
            }
            return "Unknown";
        }
        catch (ExpiredSessionException e) {
            log.info("Can not resolve remote IP address. User session expired." + e.getMessage());
            return "Unknown";
        }
    }

    public static String getClientIp(HttpServletRequest r) {
        String result = null;
        result = r.getHeader("X-Forwarded-For");
        if (result == null) {
            result = r.getRemoteAddr();
        }
        return result;
    }

    private static AbstractWebswingUser resolveUser(Subject subject, UrlHandler handler) {
        String securedPath = handler.getSecuredPath();
        if (subject != null && securedPath != null) {
            try {
                PrincipalCollection currentPrincipals = subject.getPrincipals();
                if (currentPrincipals != null && subject.isAuthenticated()) {
                    AbstractWebswingUser masteradmin = null;
                    for (WebswingPrincipal webswingPrincipal : currentPrincipals.byType(WebswingPrincipal.class)) {
                        if (handler.getRootHandler().getSecuredPath().equals(webswingPrincipal.getSecuredPath()) && webswingPrincipal.isPermitted(WebswingAction.master_admin_access.name())) {
                            masteradmin = webswingPrincipal.getUser();
                        }
                        if (!securedPath.equals(webswingPrincipal.getSecuredPath())) continue;
                        return webswingPrincipal.getUser();
                    }
                    return masteradmin;
                }
            }
            catch (UnknownSessionException e) {
                log.info("User already logged out: " + e.getMessage());
                return null;
            }
        }
        return null;
    }

    public static Object getFromSecuritySession(String attributeName) {
        Subject subject = SecurityUtils.getSubject();
        return subject.getSession().getAttribute((Object)attributeName);
    }

    public static void setToSecuritySession(String attributeName, Object value) {
        Subject subject = SecurityUtils.getSubject();
        subject.getSession().setAttribute((Object)attributeName, value);
    }

    public static void logoutUser(WebSocketConnection connection) {
        SecurityUtil.getLogoutHandle((WebSocketConnection)connection).logout();
    }

    public static LogoutHandle getLogoutHandle(WebSocketConnection conn) {
        Subject subject = (Subject)conn.getRequest().getAttribute("webswingSecuritySubject");
        return new LogoutHandle(subject, null);
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }
}

