/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.rest.resources.api;

import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.webswing.server.services.rest.resources.RestException;
import org.webswing.server.services.rest.resources.model.ApplicationInfo;
import org.webswing.server.services.rest.resources.model.ApplicationInfoMsg;
import org.webswing.server.services.rest.resources.model.BasicApplicationInfo;
import org.webswing.server.services.rest.resources.model.Manifest;
import org.webswing.server.services.rest.resources.model.Permissions;
import org.webswing.server.services.rest.resources.model.Sessions;

@Path(value="/")
public interface BasicApi {
    @GET
    @Path(value="/rest/activeSessionsCount")
    @Produces(value={"text/plain"})
    public Integer activeSessionsCount() throws RestException;

    @GET
    @Path(value="/rest/adminConsoleUrl")
    @Produces(value={"text/plain"})
    public String getAdminConsoleUrl() throws RestException;

    @GET
    @Path(value="/apps")
    @Produces(value={"application/json"})
    public List<ApplicationInfoMsg> getApps() throws RestException;

    @GET
    @Path(value="/appicon")
    @Produces(value={"image/png"})
    public File getIcon() throws RestException;

    @GET
    @Path(value="/rest/info")
    @Produces(value={"application/json"})
    public ApplicationInfo getInfo() throws RestException;

    @GET
    @Path(value="/manifest.json")
    @Produces(value={"application/json"})
    public Manifest getManifest() throws RestException;

    @GET
    @Path(value="/rest/paths")
    @Produces(value={"application/json"})
    public List<BasicApplicationInfo> getPaths() throws RestException;

    @GET
    @Path(value="/rest/permissions")
    @Produces(value={"application/json"})
    public Permissions getPermissions() throws RestException;

    @GET
    @Path(value="/rest/sessions")
    @Produces(value={"application/json"})
    public Sessions getSessions() throws RestException;

    @GET
    @Path(value="/rest/stats")
    @Produces(value={"application/json"})
    public Map<String, Map<String, BigDecimal>> getStats() throws RestException;

    @GET
    @Path(value="/rest/version")
    @Produces(value={"text/plain"})
    public String getVersion() throws RestException;

    @GET
    @Path(value="/rest/ping")
    public void ping() throws RestException;
}

