/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.stats;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Timer;
import java.util.TimerTask;
import org.webswing.server.GlobalUrlHandler;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.stats.StatisticsLogger;
import org.webswing.server.services.stats.StatisticsLoggerService;
import org.webswing.server.services.stats.logger.DefaultStatisticsLogger;
import org.webswing.toolkit.util.CpuMonitor;

@Singleton
public class StatisticsLoggerServiceImpl
implements StatisticsLoggerService {
    public static final String SERVER_LOGGER_INSTANCE_NAME = "server";
    private static final long SERVER_LOGGER_PERIOD = 1000L;
    private Timer timer;
    private GlobalUrlHandler globalUrlHandler;
    private StatisticsLogger serverLogger = new DefaultStatisticsLogger();

    @Inject
    public StatisticsLoggerServiceImpl(GlobalUrlHandler globalUrlHandler) {
        this.globalUrlHandler = globalUrlHandler;
    }

    @Override
    public void start() throws WsInitException {
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (StatisticsLoggerServiceImpl.this.globalUrlHandler.getConfig().isServerStatisticsLogging()) {
                    double cpuUsage = CpuMonitor.getCpuUtilization();
                    StatisticsLoggerServiceImpl.this.getServerLogger().log(StatisticsLoggerServiceImpl.SERVER_LOGGER_INSTANCE_NAME, "cpuUtilization", cpuUsage);
                    StatisticsLoggerServiceImpl.this.getServerLogger().log(StatisticsLoggerServiceImpl.SERVER_LOGGER_INSTANCE_NAME, "cpuUtilizationServer", cpuUsage);
                }
            }
        }, 1000L, 1000L);
    }

    @Override
    public void stop() {
        this.timer.cancel();
    }

    @Override
    public StatisticsLogger createLogger() {
        return new DefaultStatisticsLogger();
    }

    @Override
    public StatisticsLogger getServerLogger() {
        return this.serverLogger;
    }
}

