/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.extension;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ExtensionClassLoader
extends URLClassLoader {
    private ClassLoader webClassLoader;

    public ExtensionClassLoader(URL[] urls, ClassLoader webClassLoaders) {
        super(urls, ClassLoader.getSystemClassLoader());
        this.webClassLoader = webClassLoaders;
    }

    public ExtensionClassLoader() {
        this(new URL[0], ExtensionClassLoader.class.getClassLoader());
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.webClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }

    @Override
    public void close() throws IOException {
        this.webClassLoader = null;
    }

    @Override
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url == null) {
            url = this.webClassLoader.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[]{super.getResources(name), this.webClassLoader.getResources(name)};
        return new CompoundEnumeration<URL>(tmp);
    }

    class CompoundEnumeration<E>
    implements Enumeration<E> {
        private final Enumeration<E>[] enums;
        private int index;

        public CompoundEnumeration(Enumeration<E>[] enums) {
            this.enums = enums;
        }

        private boolean next() {
            while (this.index < this.enums.length) {
                if (this.enums[this.index] != null && this.enums[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public E nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            return this.enums[this.index].nextElement();
        }
    }
}

