/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.base.AbstractUrlHandler;
import org.webswing.server.base.PrimaryUrlHandler;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.services.resources.ResourceHandler;
import org.webswing.server.services.security.api.SecurityContext;
import org.webswing.server.services.security.api.WebswingAction;
import org.webswing.server.util.ServerUtil;

public class ResourceHandlerImpl
extends AbstractUrlHandler
implements ResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(ResourceHandlerImpl.class);
    private final PrimaryUrlHandler parent;
    private SecurityContext context;

    public ResourceHandlerImpl(PrimaryUrlHandler parent, SecurityContext context) {
        super(parent);
        this.parent = parent;
        this.context = context;
    }

    @Override
    protected String getPath() {
        return "";
    }

    @Override
    public boolean serve(HttpServletRequest req, HttpServletResponse res) throws WsException {
        try {
            if (req.getMethod().equals("GET") || req.getMethod().equals("PUT")) {
                return this.lookup(req).respondGet(req, res);
            }
            if (req.getMethod().equals("HEAD")) {
                return this.lookup(req).respondHead(req, res);
            }
            return false;
        }
        catch (IOException e) {
            throw new WsException("Failed to process resource.", (Throwable)e);
        }
    }

    @Override
    public long getLastModified(HttpServletRequest req) {
        return this.lookup(req).getLastModified();
    }

    protected LookupResult lookup(HttpServletRequest req) {
        LookupResult r = (LookupResult)req.getAttribute("lookupResult-" + this.getFullPathMapping());
        if (r == null) {
            r = this.lookupNoCache(req);
            req.setAttribute("lookupResult-" + this.getFullPathMapping(), (Object)r);
        }
        return r;
    }

    protected LookupResult lookupNoCache(HttpServletRequest req) {
        String path = this.getPathInfo(req);
        return this.lookupNoCache(req, path);
    }

    protected LookupResult lookupNoCache(HttpServletRequest req, String path) {
        if (path.equals("")) {
            path = "/index.html";
        }
        if (this.isForbidden(path)) {
            return new ErrorResult(404, "Forbidden");
        }
        URL url = this.context.getWebResource(path + "/index.html");
        if (url != null && !req.getPathInfo().endsWith("/")) {
            return new RedirectResult(path + "/");
        }
        if (url == null) {
            url = this.context.getWebResource(path);
        }
        if (url == null) {
            return new ErrorResult(404, "Not found");
        }
        if (this.isRestrictedAccess(path)) {
            return new ErrorResult(401, "Access restricted.");
        }
        String mimeType = this.getMimeType(url.getPath());
        try {
            return new ResourceUrl(mimeType, url.openConnection());
        }
        catch (IOException e) {
            log.error("Failed to serve path " + path + " with resource " + url.toString(), (Throwable)e);
            return new ErrorResult(500, e.getMessage());
        }
    }

    private boolean isRestrictedAccess(String path) {
        String lpath = path.toLowerCase();
        for (String restricted : this.parent.getConfig().getRestrictedResources()) {
            if (restricted.trim().isEmpty() || !lpath.startsWith(restricted.toLowerCase())) continue;
            try {
                this.checkPermission(WebswingAction.master_basic_access);
            }
            catch (WsException e) {
                log.warn("Accessing restricted resource path. Path '" + path + "' requires authentication. (matches restricted prefix '" + restricted + "')");
                return true;
            }
        }
        return false;
    }

    protected boolean isForbidden(String path) {
        String lpath = path.toLowerCase();
        return lpath.startsWith("/web-inf/") || lpath.startsWith("/meta-inf/");
    }

    protected String getMimeType(String path) {
        String mime = this.getServletContext().getMimeType(path);
        return mime != null ? mime : "application/octet-stream";
    }

    public static class ResourceUrl
    implements LookupResult {
        protected final URLConnection url;
        private String mime;

        public ResourceUrl(String mime, URLConnection url) {
            this.mime = mime;
            this.url = url;
        }

        @Override
        public long getLastModified() {
            return this.url.getLastModified();
        }

        protected void setHeaders(HttpServletResponse resp) {
            resp.setStatus(200);
            resp.setHeader("Cache-Control", "public, max-age=120");
            resp.setDateHeader("Last-Modified", this.getLastModified());
            resp.setContentType(this.mime);
            if (this.url.getContentLength() >= 0) {
                resp.setContentLength(this.url.getContentLength());
            }
        }

        @Override
        public boolean respondGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            long ims = req.getDateHeader("If-Modified-Since");
            if (ims != -1L && Math.abs(ims - this.getLastModified()) < 1000L) {
                resp.setStatus(304);
            } else {
                this.setHeaders(resp);
                ServletOutputStream os = resp.getOutputStream();
                CommonUtil.transferStreams((InputStream)this.url.getInputStream(), (OutputStream)os);
            }
            return true;
        }

        @Override
        public boolean respondHead(HttpServletRequest req, HttpServletResponse resp) {
            this.setHeaders(resp);
            return true;
        }
    }

    public static class RedirectResult
    implements LookupResult {
        private String path;

        public RedirectResult(String path) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            this.path = path;
        }

        @Override
        public long getLastModified() {
            return -1L;
        }

        @Override
        public boolean respondGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            ServerUtil.sendHttpRedirect(req, resp, this.path);
            return true;
        }

        @Override
        public boolean respondHead(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            ServerUtil.sendHttpRedirect(req, resp, this.path);
            return true;
        }
    }

    public static class ErrorResult
    implements LookupResult {
        protected final int statusCode;
        protected final String message;

        public ErrorResult(int statusCode, String message) {
            this.statusCode = statusCode;
            this.message = message;
        }

        @Override
        public long getLastModified() {
            return -1L;
        }

        @Override
        public boolean respondGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            if (this.statusCode == 404) {
                return false;
            }
            resp.sendError(this.statusCode, this.message);
            return true;
        }

        @Override
        public boolean respondHead(HttpServletRequest req, HttpServletResponse resp) {
            return false;
        }
    }

    public static interface LookupResult {
        public boolean respondGet(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

        public boolean respondHead(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

        public long getLastModified();
    }
}

