/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.stats.logger;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.webswing.server.services.stats.logger.Aggregation;
import org.webswing.server.services.stats.logger.InstanceStats;
import org.webswing.server.services.stats.logger.SummaryStats;

public class SummaryStats {
    private Map<String, Map<String, BigDecimal>> metricsLog = new HashMap();

    public void aggregate(Collection<InstanceStats> instances, String name, Aggregation aggregation) {
        HashSet timestamps = new HashSet();
        LinkedHashMap<String, BigDecimal> metric = new LinkedHashMap<String, BigDecimal>();
        for (InstanceStats instance : instances) {
            Map valueMap = (Map)instance.getStatistics().get(name);
            if (valueMap == null) continue;
            timestamps.addAll(new ArrayList(valueMap.keySet()));
        }
        for (Long key : timestamps) {
            ArrayList<Number> values = new ArrayList<Number>();
            for (InstanceStats instance : instances) {
                Map valueMap = (Map)instance.getStatistics().get(name);
                if (valueMap == null || valueMap.get(key) == null) continue;
                values.add((Number)valueMap.get(key));
            }
            metric.put(key.toString(), this.calculateValue(aggregation, values));
        }
        this.metricsLog.put(name + "." + aggregation.name(), metric);
    }

    private BigDecimal calculateValue(Aggregation rule, List<Number> list) {
        Number result = 0;
        if (list != null && list.size() > 0) {
            block4: for (Number number : list) {
                switch (1.$SwitchMap$org$webswing$server$services$stats$logger$Aggregation[rule.ordinal()]) {
                    case 1: {
                        result = Math.min(number.doubleValue(), ((Number)result).doubleValue());
                        continue block4;
                    }
                    case 2: {
                        result = Math.max(number.doubleValue(), ((Number)result).doubleValue());
                        continue block4;
                    }
                }
                result = ((Number)result).doubleValue() + number.doubleValue();
            }
            if (rule.equals((Object)Aggregation.AVG)) {
                result = ((Number)result).doubleValue() / (double)list.size();
            }
        }
        return new BigDecimal(((Object)result).toString());
    }

    public Map<String, Map<String, BigDecimal>> getStatistics() {
        return this.metricsLog;
    }
}

