/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.swingprocess;

import com.google.inject.Singleton;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.swingprocess.SwingProcess;
import org.webswing.server.services.swingprocess.SwingProcessConfig;
import org.webswing.server.services.swingprocess.SwingProcessImpl;
import org.webswing.server.services.swingprocess.SwingProcessService;
import org.webswing.toolkit.util.DeamonThreadFactory;

@Singleton
public class SwingProcessServiceImpl
implements SwingProcessService {
    private ScheduledExecutorService processHandlerThread;

    public SwingProcess create(SwingProcessConfig config) {
        return new SwingProcessImpl(config, this.processHandlerThread);
    }

    public void start() throws WsInitException {
        this.processHandlerThread = Executors.newSingleThreadScheduledExecutor(DeamonThreadFactory.getInstance((String)"Webswing Process Handler"));
    }

    public void stop() {
        this.processHandlerThread.shutdown();
    }
}

