/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.sessionpool.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.api.model.ProcessStatusEnum;
import org.webswing.server.api.services.sessionpool.ServerSessionPoolConnector;
import org.webswing.server.api.services.swinginstance.ConnectedSwingInstance;
import org.webswing.server.common.model.SwingConfig;
import org.webswing.server.common.model.meta.ConfigContext;
import org.webswing.server.common.model.meta.MetaObject;
import org.webswing.server.common.service.config.ConfigurationService;
import org.webswing.server.common.service.swingprocess.ProcessStartupParams;
import org.webswing.server.common.util.CommonUtil;
import org.webswing.server.common.util.VariableSubstitutor;
import org.webswing.server.model.exception.WsException;
import org.webswing.sessionpool.api.service.swingprocess.ProcessExitListener;
import org.webswing.sessionpool.api.service.swingprocess.SwingProcess;
import org.webswing.sessionpool.api.service.swingprocess.SwingProcessService;

public class LocalSessionPool {
    private static final Logger log = LoggerFactory.getLogger(LocalSessionPool.class);
    private ServerSessionPoolConnector connector;
    private SwingProcessService processService;
    private ConfigurationService<SwingConfig> configService;

    public LocalSessionPool(ServerSessionPoolConnector connector, SwingProcessService processService, ConfigurationService<SwingConfig> configService) {
        this.connector = connector;
        this.processService = processService;
        this.configService = configService;
    }

    public void createProcess(String userId, Map<String, String> userAttributes, String userIp, String userLocale, String userTimeZone, String customArgs, final ProcessStartupParams startupParams) throws WsException {
        SwingConfig config = this.getSwingConfig(startupParams.getPathMapping());
        VariableSubstitutor subs = VariableSubstitutor.forSwingInstance((SwingConfig)config, (String)userId, userAttributes, (String)startupParams.getInstanceId(), (String)userIp, (String)userLocale, (String)userTimeZone, (String)customArgs);
        try {
            startupParams.setAppConfig(config);
            startupParams.setFileResolver(arg_0 -> ((ConfigContext)this.getConfigContext(startupParams.getPathMapping(), config, subs)).resolveFile(arg_0));
            startupParams.setSubs(subs);
            startupParams.setAppConnectionSecret(System.getProperty("webswing.connection.secret"));
            startupParams.setWebsocketUrl(this.getWebsocketUrl(startupParams.getPathMapping()));
            SwingProcess process = this.processService.startProcess(startupParams);
            process.setProcessExitListener(new ProcessExitListener(){

                public void onClose() {
                    LocalSessionPool.this.closeProcess(startupParams.getPathMapping(), startupParams.getInstanceId());
                }
            });
            if (process.isRunning()) {
                this.registerProcessStatus(startupParams.getInstanceId(), process);
            }
            process.setProcessStatusListener(() -> this.registerProcessStatus(startupParams.getInstanceId(), process));
        }
        catch (Exception e) {
            this.closeProcess(startupParams.getPathMapping(), startupParams.getInstanceId());
            throw new WsException("Failed to create App instance.", (Throwable)e);
        }
    }

    private void registerProcessStatus(String instanceId, SwingProcess process) {
        ConnectedSwingInstance csi = this.connector.getConnectedInstanceByInstanceId(instanceId);
        if (csi == null) {
            return;
        }
        ProcessStatusEnum processStatus = ProcessStatusEnum.FINISHED;
        if (process.isRunning()) {
            processStatus = ProcessStatusEnum.RUNNING;
        } else if (process.isForceKilled()) {
            processStatus = ProcessStatusEnum.FORCE_KILLED;
        }
        csi.updateProcessStatus(processStatus);
    }

    private String getWebsocketUrl(String pathMapping) {
        String url = System.getProperty("webswing.server.websocketUrl");
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url + pathMapping + "/async/app-bin";
    }

    private SwingConfig getSwingConfig(String path) {
        return (SwingConfig)this.configService.getConfiguration(path);
    }

    private void closeProcess(String path, String instanceId) {
        try {
            this.connector.instanceClosed(path, instanceId);
        }
        catch (Throwable e) {
            log.error("Unexpected error while closing instance", e);
        }
        this.processService.closeProcess(instanceId);
    }

    public byte[] getAppConfig(String path) throws Exception {
        MetaObject config = this.configService.describeConfiguration(path, null, this.getConfigContext(path));
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsBytes((Object)config);
    }

    public byte[] getAppMeta(String path, byte[] configBytes) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Map meta = (Map)mapper.readValue(configBytes, (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (meta != null && meta.get("data") != null) {
            MetaObject config = this.configService.describeConfiguration(path, (Map)meta.get("data"), this.getConfigContext(path));
            return mapper.writeValueAsBytes((Object)config);
        }
        throw new IllegalArgumentException("Could not find meta data!");
    }

    public void saveConfig(String path, byte[] configBytes) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Map config = (Map)mapper.readValue(configBytes, (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (config == null || config.get("data") == null) {
            throw new IllegalArgumentException("Could not find config data!");
        }
        this.configService.setConfiguration(path, (Map)config.get("data"));
    }

    private ConfigContext getConfigContext(String path) {
        SwingConfig config = this.getSwingConfig(path);
        if (config == null) {
            return null;
        }
        return this.getConfigContext(path, config, this.getDefaultVariableSubstitutor(config, null));
    }

    private ConfigContext getConfigContext(String path, final SwingConfig config, final VariableSubstitutor subs) {
        return new ConfigContext(){

            public File resolveFile(String name) {
                String home = subs.replace(config.getHomeDir());
                return CommonUtil.resolveFile((String)name, (String)home, (VariableSubstitutor)subs);
            }

            public String replaceVariables(String string) {
                return subs.replace(string);
            }
        };
    }

    public void kill(String instanceId, int delayMs) {
        this.processService.kill(instanceId, delayMs);
    }

    public void killAll(String path) {
        this.processService.killAll(path);
    }

    public String resolveConfig(String path, String user, String resolve) {
        return this.getDefaultVariableSubstitutor(this.getSwingConfig(path), user).replace(resolve);
    }

    public Map<String, String> searchVariables(String path, String user, String search) {
        return this.getDefaultVariableSubstitutor(this.getSwingConfig(path), user).searchVariables(search);
    }

    public List<String> getPaths() {
        return this.configService.getPaths();
    }

    private VariableSubstitutor getDefaultVariableSubstitutor(SwingConfig config, String user) {
        String userName = user == null ? "<webswing user>" : user;
        return VariableSubstitutor.forSwingInstance((SwingConfig)config, (String)userName, null, (String)"<webswing client Id>", (String)"<webswing client IP address>", (String)"<webswing client locale>", (String)"<webswing client timezone>", (String)"<webswing custom args>");
    }
}

