/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.config.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.common.extension.ExtensionClassLoader;
import org.webswing.server.common.model.SwingConfig;
import org.webswing.server.common.service.config.AbstractConfigurationService;
import org.webswing.server.common.service.config.ConfigurationProvider;
import org.webswing.server.common.service.config.ConfigurationUpdateHandler;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.config.impl.LocalSessionPoolConfigurationProvider;
import org.webswing.sessionpool.api.base.SessionPoolService;

@Singleton
public class LocalSessionPoolConfigurationServiceImpl
extends AbstractConfigurationService<SwingConfig>
implements SessionPoolService {
    private static final Logger log = LoggerFactory.getLogger(LocalSessionPoolConfigurationServiceImpl.class);
    private final ExtensionClassLoader extensionLoader;
    private ConfigurationProvider<SwingConfig> provider;

    @Inject
    public LocalSessionPoolConfigurationServiceImpl(ExtensionClassLoader extensionLoader) {
        this.extensionLoader = extensionLoader;
    }

    public void start() throws WsInitException {
        String providerClassName = System.getProperty("webswing.configProvider", LocalSessionPoolConfigurationProvider.class.getName());
        try {
            Class providerClass = this.extensionLoader.loadClass(providerClassName);
            try {
                Constructor constructor = providerClass.getDeclaredConstructor(ConfigurationUpdateHandler.class);
                this.provider = (ConfigurationProvider)constructor.newInstance(new Object[]{this});
            }
            catch (NoSuchMethodException e) {
                this.provider = (ConfigurationProvider)providerClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new WsInitException("Could not instantiate configuration provider " + providerClassName, (Throwable)e);
        }
    }

    public void stop() {
        this.clearChangeListeners();
        if (this.provider != null) {
            try {
                this.provider.dispose();
                this.provider = null;
            }
            catch (Exception e) {
                log.error("Failed to dispose config provider", (Throwable)e);
            }
        }
    }

    protected ConfigurationProvider<SwingConfig> getProvider() {
        return this.provider;
    }

    protected ExtensionClassLoader getExtensionClassLoader() {
        return this.extensionLoader;
    }
}

