/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.config.impl;

import java.util.HashMap;
import java.util.Map;
import org.webswing.server.common.model.SwingConfig;
import org.webswing.server.common.service.config.ConfigurationUpdateHandler;
import org.webswing.server.common.service.config.MigrationConfigurationProvider;
import org.webswing.server.common.util.ConfigUtil;
import org.webswing.server.model.exception.WsInitException;

public class LocalSessionPoolConfigurationProvider
extends MigrationConfigurationProvider<SwingConfig> {
    private Map<String, Object> originalConfiguration;

    public LocalSessionPoolConfigurationProvider() throws WsInitException {
    }

    public LocalSessionPoolConfigurationProvider(ConfigurationUpdateHandler<SwingConfig> updateHandler) throws WsInitException {
        super(updateHandler);
    }

    protected Map<String, Object> initConfiguration(Map<String, Object> config) {
        this.originalConfiguration = this.cloneJsonObject(super.initConfiguration(config));
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        Map cloned = this.cloneJsonObject(this.originalConfiguration);
        for (Map.Entry entry : cloned.entrySet()) {
            if (entry.getValue() == null || !(entry.getValue() instanceof Map)) continue;
            Object swingConfig = ((Map)entry.getValue()).get("swingConfig");
            if (swingConfig != null && swingConfig instanceof Map) {
                configMap.put((String)entry.getKey(), swingConfig);
                continue;
            }
            configMap.put((String)entry.getKey(), new HashMap());
        }
        return configMap;
    }

    public SwingConfig toConfig(String path, Map<String, Object> configuration) throws Exception {
        return (SwingConfig)ConfigUtil.instantiateConfig(configuration, SwingConfig.class, (Object[])new Object[0]);
    }

    public Map<String, Object> createDefaultConfiguration(String path) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }

    public void saveConfiguration(String path, Map<String, Object> config, boolean reload) throws Exception {
        this.loadConfiguration();
        Map cloned = this.cloneJsonObject(this.originalConfiguration);
        Map saveConfig = (Map)cloned.get(path);
        saveConfig.put("swingConfig", config);
        super.saveConfiguration(path, saveConfig, reload);
    }
}

