/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.WebswingServerModule;
import org.webswing.server.WebswingServlet;
import org.webswing.server.api.GlobalUrlHandler;
import org.webswing.server.api.services.sessionpool.ServerSessionPoolConnector;
import org.webswing.server.api.services.sessionpool.SessionPoolHolderService;
import org.webswing.server.api.services.startup.StartupService;
import org.webswing.server.common.service.security.SecurableService;
import org.webswing.server.common.service.security.SecurityManagerService;
import org.webswing.server.services.sessionpool.impl.LocalSessionPoolConnector;
import org.webswing.util.GitRepositoryState;

@WebServlet(asyncSupported=true, displayName="WebswingServlet", urlPatterns={"/*"})
@MultipartConfig(fileSizeThreshold=0x500000)
public class WebswingServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(StartupService.class);
    private static final long serialVersionUID = 1962501775857788874L;
    private StartupService startup;
    private GlobalUrlHandler handler;
    private SecurityManagerService securityManager;
    private LocalSessionPoolConnector sessionPool;

    public void init() throws ServletException {
        log.info("Initializing Webswing " + GitRepositoryState.getInstance().getDescribe());
        1 servletModule = new /* Unavailable Anonymous Inner Class!! */;
        try {
            Injector injector = Guice.createInjector((Module[])new Module[]{servletModule, new WebswingServerModule()});
            this.initializeDefaultSystemProperties();
            this.startup = (StartupService)injector.getInstance(StartupService.class);
            this.startup.start();
            this.securityManager = (SecurityManagerService)injector.getInstance(SecurityManagerService.class);
            this.handler = (GlobalUrlHandler)injector.getInstance(GlobalUrlHandler.class);
            this.handler.init();
            SessionPoolHolderService sessionPoolHolder = (SessionPoolHolderService)injector.getInstance(SessionPoolHolderService.class);
            this.sessionPool = (LocalSessionPoolConnector)injector.getInstance(LocalSessionPoolConnector.class);
            sessionPoolHolder.registerSessionPool((ServerSessionPoolConnector)this.sessionPool);
        }
        catch (Exception e) {
            log.error("Initialization of Webswing failed. ", (Throwable)e);
            this.destroy();
            throw new ServletException("Webswing failed to start!", (Throwable)e);
        }
    }

    private void initializeDefaultSystemProperties() {
        String propFileUri = System.getProperty("webswing.propertiesFile");
        if (propFileUri != null) {
            try {
                File propFile = new File(URI.create(propFileUri));
                Properties p = new Properties(System.getProperties());
                try (FileInputStream propFileStream = new FileInputStream(propFile);){
                    p.load(propFileStream);
                }
                for (Map.Entry<Object, Object> prop : p.entrySet()) {
                    if (System.getProperties().containsKey(prop.getKey())) continue;
                    System.getProperties().put(prop.getKey(), prop.getValue());
                }
            }
            catch (Exception e) {
                log.error("Exception occurred during initialization of System Properties", (Throwable)e);
                System.exit(-1);
            }
        }
        System.setProperty("webswing.server.id", UUID.randomUUID().toString());
        log.info("Starting webswing server with id [" + System.getProperty("webswing.server.id") + "]...");
        if (StringUtils.isBlank((CharSequence)System.getProperty("webswing.connection.secret"))) {
            log.error("Missing webswing.connection.secret system property!");
            System.exit(-1);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)System.getProperty("webswing.connection.secret"), (CharSequence)"change_this_in_production_000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000")) {
            String msg = "Please change webswing.connection.secret system property to a non-default value in production!";
            log.error(msg, (Throwable)new IllegalStateException(msg));
        }
        if (System.getProperty("webswing.server.websocketUrl") == null) {
            throw new RuntimeException("Failed to initialized server! Missing webswing.server.websocketUrl property!");
        }
    }

    public void handleRequest(HttpServletRequest req, HttpServletResponse res) {
        this.securityManager.secure((SecurableService)this.handler, req, res);
    }

    public void destroy() {
        if (this.sessionPool != null) {
            this.sessionPool.destroy();
        }
        if (this.handler != null) {
            this.handler.destroy();
        }
        if (this.startup != null) {
            this.startup.stop();
        }
        log.info("Webswing Server Stopped.");
    }

    public void doHead(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    public void doOptions(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    public void doTrace(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handleRequest(req, res);
    }

    protected long getLastModified(HttpServletRequest req) {
        return this.handler.getLastModified(req);
    }
}

