/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.sessionpool.impl;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Map;
import org.webswing.model.adminconsole.out.SessionPoolAppMsgOut;
import org.webswing.model.adminconsole.out.SessionPoolInfoMsgOut;
import org.webswing.server.api.services.sessionpool.ServerSessionPoolConnector;
import org.webswing.server.api.services.sessionpool.SessionPoolHolderService;
import org.webswing.server.api.services.stat.StatisticsLoggerService;
import org.webswing.server.api.services.swinginstance.SwingInstanceFactory;
import org.webswing.server.api.services.swinginstance.holder.SwingInstanceHolder;
import org.webswing.server.api.services.swinginstance.holder.SwingInstanceHolderFactory;
import org.webswing.server.common.service.config.ConfigurationService;
import org.webswing.server.common.service.swingprocess.ProcessStartupParams;
import org.webswing.server.model.exception.WsException;
import org.webswing.server.model.exception.WsInitException;
import org.webswing.server.services.sessionpool.impl.LocalSessionPool;
import org.webswing.sessionpool.api.service.startup.SessionPoolStartupService;
import org.webswing.sessionpool.api.service.swingprocess.SwingProcessService;

public class LocalSessionPoolConnector
extends ServerSessionPoolConnector {
    private LocalSessionPool localSessionPool;
    private SessionPoolStartupService startup;

    @Inject
    public LocalSessionPoolConnector(SwingInstanceFactory swingInstanceFactory, SwingInstanceHolderFactory swingInstanceHolderService, StatisticsLoggerService loggerService, SessionPoolHolderService sessionPoolHolderService) throws WsInitException {
        super(swingInstanceFactory, swingInstanceHolderService, loggerService, sessionPoolHolderService);
        this.init();
    }

    private void init() throws WsInitException {
        Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});
        SwingProcessService processService = (SwingProcessService)injector.getInstance(SwingProcessService.class);
        ConfigurationService configService = (ConfigurationService)injector.getInstance((Key)new /* Unavailable Anonymous Inner Class!! */);
        this.startup = (SessionPoolStartupService)injector.getInstance(SessionPoolStartupService.class);
        this.startup.start();
        System.setProperty("sessionpool.id", this.getId());
        this.localSessionPool = new LocalSessionPool((ServerSessionPoolConnector)this, processService, configService);
    }

    public boolean isCluster() {
        return false;
    }

    public void killAll(String path) {
        this.localSessionPool.killAll(path);
    }

    public void kill(String instanceId, int delayMs) {
        this.localSessionPool.kill(instanceId, delayMs);
    }

    protected void createProcess(String connectionId, String ownerId, String userId, Map<String, String> userAttributes, String userIp, String userLocale, String userTimeZone, String customArgs, ProcessStartupParams startupParams) throws WsException {
        this.localSessionPool.createProcess(userId, userAttributes, userIp, userLocale, userTimeZone, customArgs, startupParams);
    }

    protected boolean acceptsPath(String path) {
        return true;
    }

    public byte[] getAppConfig(String path) throws Exception {
        return this.localSessionPool.getAppConfig(path);
    }

    public byte[] getAppMeta(String path, byte[] config) throws Exception {
        return this.localSessionPool.getAppMeta(path, config);
    }

    public void saveConfig(String path, byte[] config) throws Exception {
        this.localSessionPool.saveConfig(path, config);
    }

    public String resolveConfig(String path, String user, String resolve) {
        return this.localSessionPool.resolveConfig(path, user, resolve);
    }

    public Map<String, String> searchVariables(String path, String user, String search) throws Exception {
        return this.localSessionPool.searchVariables(path, user, search);
    }

    public SessionPoolInfoMsgOut getSessionPoolInfoMsg() {
        ArrayList<String> connectedServers = new ArrayList<String>();
        connectedServers.add(System.getProperty("webswing.server.id"));
        ArrayList<SessionPoolAppMsgOut> appInstances = new ArrayList<SessionPoolAppMsgOut>();
        for (String path : this.localSessionPool.getPaths()) {
            if ("/".equals(path)) continue;
            int instances = !this.instanceHolders.containsKey(path) ? 0 : ((SwingInstanceHolder)this.instanceHolders.get(path)).getRunningInstacesCount();
            appInstances.add(new SessionPoolAppMsgOut(path, instances));
        }
        return new SessionPoolInfoMsgOut(this.getId(), this.getMaxInstances(), this.getPriority(), connectedServers, appInstances);
    }

    public void destroy() {
        if (this.startup != null) {
            this.startup.stop();
        }
    }
}

