package org.sec.util.coding;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;

/**
 * @author leesoar
 * @version 1.0
 */
public class Base64 {
    // You can customize this mapping table.
    private static String base64Map = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    /** How much does it need to be divisible by the number. */
    private static int padCnt(int number, int divisor) {
        int remainder = number % divisor;
        return (remainder == 0 ? remainder : divisor - remainder);
    }

    /** Base64 encoding */
    public static String encode(byte[] byteStr) {
        String binStr = Binary.toBin(byteStr, 8);
        binStr += StringUtil.clone('0', padCnt(binStr.length(), 6));
        StringBuilder sb = new StringBuilder();
        for (String x : StringUtil.partition(binStr, 6)) {
            sb.append(base64Map.charAt(Integer.parseInt(x, 2)));
        }
        return StringUtil.rightPad(sb.toString(), padCnt(byteStr.length, 3) + sb.length(), '=');
    }

    /** Base64 decoding */
    public static byte[] decode(String str) {
        int nilCnt = StringUtil.charCount(str, '=');
        int padZeroCnt = (str.length() - nilCnt) * 6 % 8;

        StringBuilder sb = new StringBuilder();
        for (char x : str.substring(0, str.length() - nilCnt).toCharArray()) {
            sb.append(Binary.toBin(base64Map.indexOf(x), 6));
        }
        ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
        for (String b : StringUtil.partition(sb.toString().substring(0, sb.length() - padZeroCnt), 8)) {
            byteOS.write(Integer.parseInt(b, 2));
        }
        return byteOS.toByteArray();
    }

    public static String getBase64Map() {
        return base64Map;
    }

    public static void setBase64Map(String base64Map) {
        Base64.base64Map = base64Map;
    }
}
