package org.sec.util.coding;

/**
 * @author leesoar
 * @version 1.0
 */
public class Binary {

    /** Char to binary */
    public static String toBin(char str, int size) {
        return StringUtil.leftPad(Integer.toBinaryString(str), size, '0');

    }

    /** Int to binary */
    public static String toBin(int number, int size) {
        return StringUtil.leftPad(Integer.toBinaryString(number), size, '0');

    }

    /** String to binary */
    public static String toBin(String str, int size) {
        StringBuilder sb = new StringBuilder();
        for (char x : str.toCharArray()) {
            sb.append(toBin(x, size));
        }
        return sb.toString();
    }

    /** Bytes to binary */
    public static String toBin(byte[] str, int size) {
        StringBuilder sb = new StringBuilder();
        for (byte s : str) {
            sb.append(StringUtil.leftPad(Integer.toBinaryString(s & 0xff), size, '0'));
        }
        return sb.toString();
    }
}



