package org.sec.util.coding;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @author leesoar
 * @version 1.0
 */
public class StringUtil {
    /**
     * Left pad any character.
     */
    public static String leftPad(String str, int size, char padChar) {
        int count = size - str.length();
        return count > 0 ? clone(padChar, count) + str : str;
    }

    /**
     * Right pad any character.
     */
    public static String rightPad(String str, int size, char padChar) {
        int count = size - str.length();
        return count > 0 ? str + clone(padChar, count) : str;
    }

    /**
     * Copy the given n characters.
     */
    public static String clone(char str, int count) {
        return CharBuffer.allocate(count).toString().replace('\0', str);
    }

    /**
     * Equal parts string.
     */
    public static List<String> partition(String str, int length) {
        List<String> retList = new ArrayList<>();

        for (int i = 0; i < str.length(); i += length)
            if (str.length() - i < length) {
                retList.add(str.substring(i));
            } else {
                retList.add(str.substring(i, i + length));
            }
        return retList;
    }

    /**
     * Returns hashMap of characters count.
     */
    public static HashMap<Character, Integer> charCount(String str) {
        HashMap<Character, Integer> hashMap = new HashMap<>();
        for (char x : str.toCharArray()) {
            hashMap.compute(x, (k, v) -> v == null ? 1 : v + 1);
        }
        return hashMap;
    }

    /**
     * Returns integer of given character count.
     */
    public static int charCount(String str, char charStr) {
        return charCount(str).getOrDefault(charStr, 0);
    }
}
