/*
 * Decompiled with CFR 0.152.
 */
package org.sec.util.coding;

import java.io.ByteArrayOutputStream;
import org.sec.util.coding.Binary;
import org.sec.util.coding.StringUtil;

public class Base64 {
    private static String base64Map = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    private static int padCnt(int number, int divisor) {
        int remainder = number % divisor;
        return remainder == 0 ? remainder : divisor - remainder;
    }

    public static String encode(byte[] byteStr) {
        String binStr = Binary.toBin(byteStr, 8);
        binStr = binStr + StringUtil.clone('0', Base64.padCnt(binStr.length(), 6));
        StringBuilder sb = new StringBuilder();
        for (String x : StringUtil.partition(binStr, 6)) {
            sb.append(base64Map.charAt(Integer.parseInt(x, 2)));
        }
        return StringUtil.rightPad(sb.toString(), Base64.padCnt(byteStr.length, 3) + sb.length(), '=');
    }

    public static byte[] decode(String str) {
        int nilCnt = StringUtil.charCount(str, '=');
        int padZeroCnt = (str.length() - nilCnt) * 6 % 8;
        StringBuilder sb = new StringBuilder();
        for (char x : str.substring(0, str.length() - nilCnt).toCharArray()) {
            sb.append(Binary.toBin(base64Map.indexOf(x), 6));
        }
        ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
        for (String b : StringUtil.partition(sb.toString().substring(0, sb.length() - padZeroCnt), 8)) {
            byteOS.write(Integer.parseInt(b, 2));
        }
        return byteOS.toByteArray();
    }

    public static String getBase64Map() {
        return base64Map;
    }

    public static void setBase64Map(String base64Map) {
        Base64.base64Map = base64Map;
    }
}

