/*
 * Decompiled with CFR 0.152.
 */
package org.sec.util.coding;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StringUtil {
    public static String leftPad(String str, int size, char padChar) {
        int count = size - str.length();
        return count > 0 ? StringUtil.clone(padChar, count) + str : str;
    }

    public static String rightPad(String str, int size, char padChar) {
        int count = size - str.length();
        return count > 0 ? str + StringUtil.clone(padChar, count) : str;
    }

    public static String clone(char str, int count) {
        return CharBuffer.allocate(count).toString().replace('\u0000', str);
    }

    public static List<String> partition(String str, int length) {
        ArrayList<String> retList = new ArrayList<String>();
        for (int i = 0; i < str.length(); i += length) {
            if (str.length() - i < length) {
                retList.add(str.substring(i));
                continue;
            }
            retList.add(str.substring(i, i + length));
        }
        return retList;
    }

    public static HashMap<Character, Integer> charCount(String str) {
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>();
        for (char x : str.toCharArray()) {
            hashMap.compute(Character.valueOf(x), (k, v) -> v == null ? 1 : v + 1);
        }
        return hashMap;
    }

    public static int charCount(String str, char charStr) {
        return StringUtil.charCount(str).getOrDefault(Character.valueOf(charStr), 0);
    }
}

