/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.asserts;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.whaka.asserts.AssertError;
import org.whaka.asserts.AssertResult;
import org.whaka.asserts.matcher.ResultProvidingMatcher;

public class AssertBuilder {
    private final List<AssertResult> assertResults = new ArrayList<AssertResult>();

    public final List<AssertResult> getAssertResults() {
        return this.assertResults;
    }

    public Optional<AssertError> build() {
        return this.assertResults.size() > 0 ? Optional.of(new AssertError(this.assertResults)) : Optional.empty();
    }

    public void performAssert() throws AssertError {
        Optional<AssertError> error = this.build();
        if (error.isPresent()) {
            throw error.get();
        }
    }

    public AssertBuilder addResult(AssertResult result) {
        Objects.requireNonNull(result, "Assert result cannot be null!");
        this.assertResults.add(result);
        return this;
    }

    public AssertBuilder addMessage(String message, Object ... args) {
        Objects.requireNonNull(message, "Message cannot be null!");
        if (args.length > 0) {
            message = String.format(message, args);
        }
        this.addResult(new AssertResult(message));
        return this;
    }

    public <T> AssertBuilder checkThat(T item, Matcher<T> matcher) {
        return this.checkThat(item, matcher, null);
    }

    public <T> AssertBuilder checkThat(T item, Matcher<T> matcher, String message) {
        return this.checkThat(item, matcher, message, null);
    }

    public <T> AssertBuilder checkThat(T item, Matcher<T> matcher, String message, Throwable cause) {
        AssertBuilder.performCheck(item, matcher, message, cause).ifPresent(this::addResult);
        return this;
    }

    private static <T> Optional<? extends AssertResult> performCheck(T item, Matcher<T> matcher, String message, Throwable cause) {
        if (matcher instanceof ResultProvidingMatcher) {
            return ((ResultProvidingMatcher)matcher).matches(item, message, cause);
        }
        if (!matcher.matches(item)) {
            return Optional.of(AssertBuilder.createDefaultResult(item, matcher, message, cause));
        }
        return Optional.empty();
    }

    private static <T> AssertResult createDefaultResult(T item, Matcher<T> matcher, String message, Throwable cause) {
        StringDescription expected = new StringDescription();
        matcher.describeTo((Description)expected);
        return new AssertResult(item, expected.toString(), message, cause);
    }
}

