/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.asserts;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.whaka.asserts.AssertResult;

public class AssertError
extends Error {
    private final List<AssertResult> results;

    public AssertError(Collection<AssertResult> results) {
        super(AssertError.formatMessage(results));
        Preconditions.checkArgument((results.size() > 0 ? 1 : 0) != 0, (Object)"At least one assert result is required!");
        this.results = Collections.unmodifiableList(new ArrayList<AssertResult>(results));
    }

    public List<AssertResult> getResults() {
        return this.results;
    }

    /*
     * Exception decompiling
     */
    private static String formatMessage(Collection<AssertResult> results) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getResults()});
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            AssertError that = (AssertError)object;
            return Objects.equal(this.getResults(), that.getResults());
        }
        return false;
    }
}

