/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.asserts;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class AssertResult {
    private Object actual;
    private Object expected;
    private String message;
    private Throwable cause;

    public AssertResult() {
    }

    public AssertResult(String message) {
        this(message, null);
    }

    public AssertResult(String message, Throwable cause) {
        this(null, null, message, cause);
    }

    public AssertResult(Object actual, Object expected, String message) {
        this(actual, expected, message, null);
    }

    public AssertResult(Object actual, Object expected, String message, Throwable cause) {
        this.actual = actual;
        this.expected = expected;
        this.message = message;
        this.cause = cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setActual(Object actual) {
        this.actual = actual;
    }

    public Object getActual() {
        return this.actual;
    }

    public void setExpected(Object expected) {
        this.expected = expected;
    }

    public Object getExpected() {
        return this.expected;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)this);
        if (this.getActual() != null || this.getExpected() != null) {
            tsh.add("actual", this.getActual());
            tsh.add("expected", this.getExpected());
        }
        if (this.getMessage() != null) {
            tsh.add("message", (Object)this.getMessage());
        }
        if (this.getCause() != null) {
            tsh.add("cause", this.getCause().getClass());
        }
        return tsh.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getActual(), this.getExpected(), this.getMessage(), this.getCause()});
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            AssertResult that = (AssertResult)object;
            return Objects.equal((Object)this.getActual(), (Object)that.getActual()) && Objects.equal((Object)this.getExpected(), (Object)that.getExpected()) && Objects.equal((Object)this.getMessage(), (Object)that.getMessage()) && Objects.equal((Object)this.getCause(), (Object)that.getCause());
        }
        return false;
    }
}

