/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.asserts;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.whaka.asserts.AssertResult;
import org.whaka.util.reflection.comparison.ComparisonFail;
import org.whaka.util.reflection.comparison.ComparisonResult;
import org.whaka.util.reflection.comparison.ComplexComparisonResult;

public class ComparisonAssertResult
extends AssertResult {
    private ComparisonResult comparisonResult;

    public ComparisonAssertResult(ComparisonResult comparisonResult) {
        this(comparisonResult, null);
    }

    public ComparisonAssertResult(ComparisonResult comparisonResult, String message) {
        super(message);
        Objects.requireNonNull(comparisonResult, "Comparison result cannot be null!");
        Preconditions.checkArgument((!comparisonResult.isSuccess() ? 1 : 0) != 0, (Object)"Assert shouldn't be created from successful result!");
        this.comparisonResult = comparisonResult;
    }

    public static ComparisonAssertResult createWithCause(ComparisonResult result) {
        return ComparisonAssertResult.createWithCause(result, null);
    }

    public static ComparisonAssertResult createWithCause(ComparisonResult result, String message) {
        ComparisonAssertResult assertResult = new ComparisonAssertResult(result, message);
        if (result instanceof ComparisonFail) {
            assertResult.setCause(((ComparisonFail)result).getCause());
        }
        return assertResult;
    }

    public ComparisonResult getComparisonResult() {
        return this.comparisonResult;
    }

    @Override
    public Object getActual() {
        return this.getComparisonResult().getActual();
    }

    @Override
    public Object getExpected() {
        return this.getComparisonResult().getExpected();
    }

    @Override
    public void setActual(Object actual) {
        throw new UnsupportedOperationException("Cannot set actual value to performed result!");
    }

    @Override
    public void setExpected(Object expected) {
        throw new UnsupportedOperationException("Cannot set expected value to performed result!");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getComparisonResult());
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            ComparisonAssertResult that = (ComparisonAssertResult)object;
            return Objects.equals(this.getMessage(), that.getMessage()) && Objects.equals(this.getCause(), that.getCause()) && Objects.equals(this.getComparisonResult(), that.getComparisonResult());
        }
        return false;
    }

    @Override
    public String toString() {
        String head = this.formatHeadString();
        ComparisonResult comparisonResult = this.getComparisonResult();
        if (comparisonResult instanceof ComplexComparisonResult) {
            return ComparisonAssertResult.formatComplexResult(head, (ComplexComparisonResult)comparisonResult);
        }
        return head;
    }

    private String formatHeadString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper((Object)this).add("actual", this.getActual()).add("expected", this.getExpected());
        if (this.getMessage() != null) {
            tsh.add("message", (Object)this.getMessage());
        }
        if (this.getCause() != null) {
            tsh.add("cause", this.getCause().getClass());
        }
        tsh.add("performer", this.getComparisonResult().getComparisonPerformer());
        return tsh.toString();
    }

    /*
     * Exception decompiling
     */
    private static String formatComplexResult(String head, ComplexComparisonResult result) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

