/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.asserts;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.whaka.asserts.matcher.FunctionalMatcher;
import org.whaka.util.DoubleMath;

public final class NumberMatchers {
    private static final Supplier<Matcher<Double>> IS_NUMBER = Suppliers.memoize(() -> new FunctionalMatcher<Double>(Double.class, DoubleMath::isNumber, "number"));
    private static final Supplier<Matcher<Double>> IS_FINITE = Suppliers.memoize(() -> new FunctionalMatcher<Double>(Double.class, DoubleMath::isFinite, "finite number"));
    private static final Supplier<Matcher<Number>> IS_ZERO = Suppliers.memoize(() -> new FunctionalMatcher<Number>(Number.class, NumberMatchers.convertPredicate(DoubleMath::isZero), d -> d.appendValue((Object)0)));
    private static final Supplier<Matcher<Number>> IS_POSITIVE = Suppliers.memoize(() -> new FunctionalMatcher<Number>(Number.class, NumberMatchers.convertPredicate(DoubleMath::isPositive), "positive number"));
    private static final Supplier<Matcher<Number>> IS_NEGATIVE = Suppliers.memoize(() -> new FunctionalMatcher<Number>(Number.class, NumberMatchers.convertPredicate(DoubleMath::isNegative), "negative number"));

    private NumberMatchers() {
    }

    public static Matcher<Double> number() {
        return (Matcher)IS_NUMBER.get();
    }

    public static Matcher<Double> finite() {
        return (Matcher)IS_FINITE.get();
    }

    public static Matcher<Number> zero() {
        return (Matcher)IS_ZERO.get();
    }

    public static Matcher<Number> positive() {
        return (Matcher)IS_POSITIVE.get();
    }

    public static Matcher<Number> negative() {
        return (Matcher)IS_NEGATIVE.get();
    }

    private static Predicate<Number> convertPredicate(Predicate<Double> delegate) {
        return a -> delegate.test(DoubleMath.asDouble(a));
    }

    public static Matcher<Number> equalTo(Number value) {
        return new FunctionalMatcher<Number>(Number.class, NumberMatchers.convertBiPredicate(DoubleMath::equals, value), NumberMatchers.createSingleValueDescriber("equal to", value));
    }

    private static Predicate<Number> convertBiPredicate(BiPredicate<Double, Double> delegate, Number value) {
        return a -> delegate.test(DoubleMath.asDouble(a), DoubleMath.asDouble(value));
    }

    public static Matcher<Number> greaterThan(Number value) {
        return NumberMatchers.createCompareMatcher(value, i -> i > 0, "greater than");
    }

    public static Matcher<Number> lowerThan(Number value) {
        return NumberMatchers.createCompareMatcher(value, i -> i < 0, "lower than");
    }

    public static Matcher<Number> greaterThanOrEqual(Number value) {
        return NumberMatchers.createCompareMatcher(value, i -> i >= 0, "greater than or equal to");
    }

    public static Matcher<Number> lowerThanOrEqual(Number value) {
        return NumberMatchers.createCompareMatcher(value, i -> i <= 0, "lower than or equal to");
    }

    private static Matcher<Number> createCompareMatcher(Number value, IntPredicate predicate, String op) {
        Objects.requireNonNull(value, "Cannot compare to null!");
        return new FunctionalMatcher<Number>(Number.class, NumberMatchers.convertCompareResultPredicate(predicate, value), NumberMatchers.createSingleValueDescriber(op, value));
    }

    private static Predicate<Number> convertCompareResultPredicate(IntPredicate predicate, Number value) {
        return NumberMatchers.convertBiPredicate((a, b) -> a != null && b != null && predicate.test(DoubleMath.compare(a, b)), value);
    }

    private static Consumer<Description> createSingleValueDescriber(String operationName, Number value) {
        return d -> d.appendText(String.format("number %s ", operationName)).appendValue((Object)value);
    }

    public static Matcher<Number> between(Number min, Number max) {
        return NumberMatchers.createBiCompareMatcher(min, max, (a, b) -> a > 0 && b < 0, "number between");
    }

    public static Matcher<Number> betweenOrEqual(Number min, Number max) {
        return NumberMatchers.createBiCompareMatcher(min, max, (a, b) -> a >= 0 && b <= 0, "number between or equal");
    }

    private static Matcher<Number> createBiCompareMatcher(Number min, Number max, BiPredicate<Integer, Integer> predicate, String op) {
        Objects.requireNonNull(min, "Cannot compare to null!");
        Objects.requireNonNull(max, "Cannot compare to null!");
        Preconditions.checkArgument((DoubleMath.compare(DoubleMath.asDouble(min), DoubleMath.asDouble(max)) <= 0 ? 1 : 0) != 0, (Object)"min is greater than max!");
        return new FunctionalMatcher<Number>(Number.class, NumberMatchers.convertBiCompareResultPredicate(predicate, min, max), NumberMatchers.createBiCompareDescriber(op, min, max));
    }

    private static Predicate<Number> convertBiCompareResultPredicate(BiPredicate<Integer, Integer> predicate, Number a, Number b) {
        return NumberMatchers.convertPredicate(x -> x != null && predicate.test(DoubleMath.compare(x, DoubleMath.asDouble(a)), DoubleMath.compare(x, DoubleMath.asDouble(b))));
    }

    private static Consumer<Description> createBiCompareDescriber(String operationName, Number min, Number max) {
        return d -> d.appendText(operationName + " ").appendValue((Object)min).appendText(" and ").appendValue((Object)max);
    }
}

