/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.asserts;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.whaka.asserts.matcher.ComparisonMatcher;
import org.whaka.asserts.matcher.ConsistencyMatcher;
import org.whaka.asserts.matcher.FunctionalMatcher;
import org.whaka.asserts.matcher.RegexpMatcher;
import org.whaka.asserts.matcher.ThrowableMatcher;
import org.whaka.util.UberCollections;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.ComparisonPerformers;

public final class UberMatchers {
    private UberMatchers() {
    }

    public static <T> Matcher<T> equalTo(T item, ComparisonPerformer<? super T> performer) {
        return new ComparisonMatcher<T>(item, performer);
    }

    public static <T> Matcher<T> deeplyEqualTo(T item) {
        return UberMatchers.equalTo(item, ComparisonPerformers.DEEP_EQUALS);
    }

    public static <T> Matcher<T> reflectivelyEqualTo(T item) {
        return UberMatchers.equalTo(item, ComparisonPerformers.REFLECTIVE_EQUALS);
    }

    public static <T> Matcher<T> consistentWith(T value, Matcher<? super T> matcher) {
        return new ConsistencyMatcher<T>(value, matcher);
    }

    public static Matcher<Object> nullConsistentWith(Object value) {
        return UberMatchers.consistentWith(value, Matchers.nullValue());
    }

    public static Matcher<Object> matches(String pattern) {
        return RegexpMatcher.create(pattern);
    }

    public static Matcher<Object> matches(Pattern pattern) {
        return RegexpMatcher.create(pattern);
    }

    public static Matcher<Throwable> throwableOfType(Class<? extends Throwable> type) {
        return ThrowableMatcher.throwableOfType(type);
    }

    public static Matcher<Throwable> notExpected() {
        return ThrowableMatcher.notExpected();
    }

    public static <T> Matcher<Collection<? extends T>> hasItem(T item, BiPredicate<T, T> matcher) {
        Objects.requireNonNull(matcher, "Predicate cannot be null!");
        return new FunctionalMatcher<Collection>(Collection.class, c -> UberCollections.contains(c, item, matcher), d -> d.appendText("has item ").appendValue(item).appendText(" with a predicate"));
    }

    public static <T> Matcher<Collection<? extends T>> hasAnyItem(Collection<T> items) {
        return UberMatchers.hasAnyItem(items, Objects::deepEquals);
    }

    public static <T> Matcher<Collection<? extends T>> hasAnyItem(Collection<T> items, BiPredicate<T, T> matcher) {
        Objects.requireNonNull(items, "Items collection cannot be null!");
        Objects.requireNonNull(matcher, "Predicate cannot be null!");
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0, (Object)"Items cannot be empty!");
        return new FunctionalMatcher<Collection>(Collection.class, c -> UberCollections.containsAny(c, items, matcher), d -> d.appendText("has any one of ").appendValue((Object)items).appendText(" with a predicate"));
    }

    public static <T> Matcher<T> isIn(Collection<? extends T> col, BiPredicate<T, T> matcher) {
        Objects.requireNonNull(col, "Collection cannot be null!");
        Objects.requireNonNull(matcher, "Predicate cannot be null!");
        return new FunctionalMatcher<Object>(Object.class, t -> UberCollections.contains(col, t, matcher), d -> d.appendText("one of ").appendValue((Object)col).appendText(" with a predicate"));
    }

    public static <T, V> Matcher<V> convert(Matcher<T> m, Function<V, T> f) {
        Objects.requireNonNull(m, "Delegate matcher cannot be null!");
        Objects.requireNonNull(f, "Converting function cannot be null!");
        return new FunctionalMatcher<Object>(Object.class, v -> m.matches(f.apply(v)), d -> m.describeTo(d));
    }
}

