/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.asserts.matcher;

import java.util.Objects;
import java.util.Optional;
import org.hamcrest.Description;
import org.whaka.asserts.ComparisonAssertResult;
import org.whaka.asserts.matcher.ResultProvidingMatcher;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.ComparisonResult;

public class ComparisonMatcher<T>
extends ResultProvidingMatcher<T> {
    private final T value;
    private final ComparisonPerformer<? super T> comparisonPerformer;

    public ComparisonMatcher(T value, ComparisonPerformer<? super T> comparisonPerformer) {
        this.value = value;
        this.comparisonPerformer = Objects.requireNonNull(comparisonPerformer, "Comparison performer cannot be null!");
    }

    public T getValue() {
        return this.value;
    }

    public ComparisonPerformer<? super T> getComparisonPerformer() {
        return this.comparisonPerformer;
    }

    @Override
    public Optional<ComparisonAssertResult> matches(T item, String message, Throwable cause) {
        Object comparisonResult = this.getComparisonPerformer().apply((Object)item, (Object)this.getValue());
        if (((ComparisonResult)comparisonResult).isSuccess()) {
            return Optional.empty();
        }
        ComparisonAssertResult result = ComparisonAssertResult.createWithCause((ComparisonResult)comparisonResult, message);
        if (result.getCause() == null) {
            result.setCause(cause);
        }
        return Optional.of(result);
    }

    public void describeTo(Description description) {
        description.appendText("equal to ").appendValue(this.getValue()).appendText(" according to " + this.getComparisonPerformer());
    }
}

